/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.common.spring;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import net.lemnik.eodsql.impl.ExceptionTranslationUtils;
import net.lemnik.eodsql.impl.ExceptionTranslator;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator;

public class SpringEoDSQLExceptionTranslator
implements ExceptionTranslator {
    public static void activate() {
        ExceptionTranslationUtils.setExceptionTranslator((ExceptionTranslator)new SpringEoDSQLExceptionTranslator());
    }

    public RuntimeException translateException(DataSource dataSource, String task, String sql, SQLException ex) {
        return new SQLErrorCodeSQLExceptionTranslator(dataSource).translate(task, sql, ex);
    }

    public RuntimeException translateException(Connection connection, String task, String sql, SQLException ex) {
        try {
            String databaseProductName = connection.getMetaData().getDatabaseProductName();
            return new SQLErrorCodeSQLExceptionTranslator(databaseProductName).translate(task, sql, ex);
        }
        catch (SQLException ex1) {
            return new SQLErrorCodeSQLExceptionTranslator().translate(task, sql, ex);
        }
    }

    public RuntimeException uniqueResultExpected() {
        return new IncorrectResultSizeDataAccessException("A unique result was expected but the database returned multiple rows.", 1);
    }
}

