/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.client.admin;

import ch.systemsx.cisd.args4j.CmdLineParser;
import ch.systemsx.cisd.args4j.ExampleMode;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.properties.ExtendedProperties;
import ch.systemsx.cisd.common.ssl.SslCertificateHelper;
import ch.systemsx.cisd.openbis.common.api.client.ServiceFinder;
import ch.systemsx.cisd.openbis.dss.client.admin.CommonArguments;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.IDssServiceRpcGeneric;
import ch.systemsx.cisd.openbis.dss.generic.shared.content.DssServiceRpcGenericFactory;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.DssPropertyParametersUtil;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.IGeneralInformationService;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

abstract class AbstractCommand {
    static final String BASH_COMMAND = "share-manager.sh";
    private final String name;
    protected String sessionToken;
    protected IDssServiceRpcGeneric service;

    AbstractCommand(String name) {
        this.name = name;
    }

    String getName() {
        return this.name;
    }

    void parseArguments(String[] args) {
        CommonArguments arguments = this.getArguments();
        CmdLineParser parser = new CmdLineParser(arguments);
        try {
            parser.parseArgument(args);
            if (!arguments.isComplete()) {
                throw new IllegalArgumentException();
            }
        }
        catch (Exception ex) {
            StringWriter writer = new StringWriter();
            PrintWriter out = new PrintWriter((Writer)writer, true);
            String cmdString = "share-manager.sh " + this.getName();
            out.println("Usage: " + cmdString + " [options] " + this.getRequiredArgumentsString());
            parser.printUsage(writer, null);
            out.println("Example: " + cmdString + parser.printExample(ExampleMode.ALL) + " " + this.getRequiredArgumentsString());
            throw new UserFailureException(writer.toString());
        }
    }

    void login() {
        String username = this.getArguments().getUsername();
        if (StringUtils.isBlank((CharSequence)username)) {
            throw new UserFailureException("Unspecified user name.");
        }
        String password = this.getArguments().getPassword();
        if (StringUtils.isBlank((CharSequence)password)) {
            throw new UserFailureException("Unspecified password.");
        }
        Properties properties = this.loadServiceProperties();
        String openBisServerUrl = DssPropertyParametersUtil.getOpenBisServerUrl(properties);
        IGeneralInformationService infoService = this.createGeneralInfoService(openBisServerUrl);
        this.sessionToken = infoService.tryToAuthenticateForAllServices(username, password);
        if (this.sessionToken == null) {
            throw new UserFailureException("Invalid username/password combination.");
        }
        String downloadUrl = DssPropertyParametersUtil.getDownloadUrl(properties);
        this.service = this.createDssService(downloadUrl);
    }

    IDssServiceRpcGeneric createDssService(String downloadUrl) {
        SslCertificateHelper.trustAnyCertificate(downloadUrl);
        return new DssServiceRpcGenericFactory().getService(downloadUrl);
    }

    IGeneralInformationService createGeneralInfoService(String openBisServerUrl) {
        SslCertificateHelper.trustAnyCertificate(openBisServerUrl);
        ServiceFinder serviceFinder = new ServiceFinder("openbis", "/rmi-general-information-v1");
        return serviceFinder.createService(IGeneralInformationService.class, openBisServerUrl);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties loadServiceProperties() {
        ExtendedProperties extendedProperties;
        CommonArguments arguments = this.getArguments();
        File servicPropertiesFile = arguments.getServicPropertiesFile();
        FileReader reader = null;
        try {
            reader = new FileReader(servicPropertiesFile);
            Properties properties = new Properties();
            properties.load(reader);
            extendedProperties = ExtendedProperties.createWith(properties);
        }
        catch (FileNotFoundException ex) {
            try {
                String string;
                StringBuilder stringBuilder = new StringBuilder().append("DSS service.properties file not found: ").append(servicPropertiesFile.getAbsolutePath());
                if (arguments.isServicePropertiesPathSpecified()) {
                    string = "";
                    throw new UserFailureException(stringBuilder.append(string).toString());
                }
                string = "\nUse option -sp to specify it.";
                throw new UserFailureException(stringBuilder.append(string).toString());
                catch (IOException ex2) {
                    throw new UserFailureException("Error while loading '" + servicPropertiesFile.getAbsolutePath() + "': " + ex2, ex2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        return extendedProperties;
    }

    protected abstract CommonArguments getArguments();

    protected abstract String getRequiredArgumentsString();

    abstract void execute();
}

