/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.client.api.cli;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.InvalidSessionException;
import ch.systemsx.cisd.common.exceptions.MasqueradingException;
import ch.systemsx.cisd.common.exceptions.SystemExitException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.utilities.IExitHandler;
import ch.systemsx.cisd.openbis.dss.client.api.cli.ICommand;
import ch.systemsx.cisd.openbis.dss.client.api.cli.ICommandFactory;
import ch.systemsx.cisd.openbis.dss.client.api.cli.ResultCode;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Arrays;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.remoting.RemoteAccessException;
import org.springframework.remoting.RemoteConnectFailureException;

public class AbstractClient {
    protected final IExitHandler exitHandler;
    protected final ICommandFactory commandFactory;

    protected static void disableLogging() {
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.NoOpLog");
    }

    protected static void enableDebugLogging() {
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.SimpleLog");
        System.setProperty("org.apache.commons.logging.simplelog.showdatetime", "true");
        System.setProperty("org.apache.commons.logging.simplelog.log.httpclient.wire.header", "debug");
        System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.commons.httpclient", "debug");
    }

    public AbstractClient(IExitHandler exitHandler, ICommandFactory commandFactory) {
        this.exitHandler = exitHandler;
        this.commandFactory = commandFactory;
    }

    protected void runWithArgs(String[] args) {
        ICommand command = this.getCommandOrDie(args);
        int exitCode = 0;
        try {
            String[] cmdArgs = new String[args.length - 1];
            Arrays.asList(args).subList(1, args.length).toArray(cmdArgs);
            ResultCode result = command.execute(cmdArgs);
            exitCode = result.getValue();
        }
        catch (InvalidSessionException ex) {
            System.err.println("Your session is no longer valid. Please login again. [server said: '" + ex.getMessage() + "']");
            exitCode = ResultCode.INVALID_SESSION.getValue();
        }
        catch (UserFailureException ex) {
            System.err.println();
            System.err.println(ex.getMessage());
            exitCode = ResultCode.USER_ERROR.getValue();
        }
        catch (EnvironmentFailureException ex) {
            System.err.println();
            System.err.println(ex.getMessage() + " (environment failure)");
            exitCode = ResultCode.ENVIRONMENT_ERROR.getValue();
        }
        catch (RemoteConnectFailureException ex) {
            System.err.println();
            System.err.println("Remote server cannot be reached (environment failure)");
            exitCode = ResultCode.NO_CONNECTION_TO_SERVER.getValue();
        }
        catch (RemoteAccessException ex) {
            System.err.println();
            Throwable cause = ex.getCause();
            if (cause != null) {
                if (cause instanceof UnknownHostException) {
                    System.err.println(String.format("Given host '%s' can not be reached  (environment failure)", cause.getMessage()));
                    exitCode = ResultCode.NO_CONNECTION_TO_SERVER.getValue();
                } else if (cause instanceof IllegalArgumentException) {
                    System.err.println(cause.getMessage());
                    exitCode = ResultCode.UNKNOWN_ERROR.getValue();
                } else if (cause instanceof SSLHandshakeException) {
                    String property = "javax.net.ssl.trustStore";
                    System.err.println(String.format("Validation of SSL certificate failed [%s=%s] (configuration failure)", "javax.net.ssl.trustStore", StringUtils.defaultString((String)System.getProperty("javax.net.ssl.trustStore"))));
                    exitCode = ResultCode.ENVIRONMENT_ERROR.getValue();
                } else if (cause instanceof SocketTimeoutException) {
                    System.err.println(String.format("Connection to server timed out (environment failure)", cause.getMessage()));
                    exitCode = ResultCode.NO_CONNECTION_TO_SERVER.getValue();
                } else if (cause instanceof SocketException) {
                    System.err.println(String.format("Connection to server timed out (environment failure)", cause.getMessage()));
                    exitCode = ResultCode.NO_CONNECTION_TO_SERVER.getValue();
                } else {
                    ex.printStackTrace();
                    exitCode = ResultCode.UNKNOWN_ERROR.getValue();
                }
            } else {
                ex.printStackTrace();
                exitCode = ResultCode.UNKNOWN_ERROR.getValue();
            }
        }
        catch (SystemExitException e) {
            exitCode = ResultCode.UNKNOWN_ERROR.getValue();
        }
        catch (MasqueradingException e) {
            System.err.println(e);
            exitCode = ResultCode.UNKNOWN_ERROR.getValue();
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
            exitCode = ResultCode.UNKNOWN_ERROR.getValue();
        }
        catch (Exception e) {
            System.err.println();
            e.printStackTrace();
            exitCode = ResultCode.UNKNOWN_ERROR.getValue();
        }
        this.exitHandler.exit(exitCode);
    }

    private ICommand getCommandOrDie(String[] args) {
        if (args.length < 1) {
            ICommand help = this.commandFactory.getHelpCommand();
            help.printUsage(System.err);
            this.exitHandler.exit(1);
            return null;
        }
        String commandName = args[0];
        ICommand command = this.commandFactory.tryCommandForName(commandName);
        if (null == command) {
            ICommand help = this.commandFactory.getHelpCommand();
            help.printUsage(System.err);
            this.exitHandler.exit(1);
            return null;
        }
        return command;
    }
}

