/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.client.api.cli;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.dss.client.api.cli.AbstractCommand;
import ch.systemsx.cisd.openbis.dss.client.api.cli.GlobalArguments;
import ch.systemsx.cisd.openbis.dss.client.api.cli.ICommand;
import ch.systemsx.cisd.openbis.dss.client.api.cli.ICommandFactory;
import ch.systemsx.cisd.openbis.dss.client.api.cli.ResultCode;
import java.io.PrintStream;
import java.util.List;

public class CommandHelp
extends AbstractCommand<CommandHelpArguments> {
    private final ICommandFactory commandFactory;
    private final String programCallString;

    public CommandHelp(ICommandFactory factory, String programCallString) {
        super(new CommandHelpArguments());
        this.commandFactory = factory;
        this.programCallString = programCallString;
    }

    @Override
    public ResultCode execute(String[] args) throws UserFailureException, EnvironmentFailureException {
        this.parser.parseArgument(args);
        if (((CommandHelpArguments)this.arguments).getArguments().size() < 1) {
            this.printUsage(System.out);
            return ResultCode.INVALID_ARGS;
        }
        ICommand cmd = this.commandFactory.tryCommandForName(((CommandHelpArguments)this.arguments).getArguments().get(0));
        if (null == cmd) {
            this.printUsage(System.out);
            return ResultCode.INVALID_ARGS;
        }
        cmd.printUsage(System.out);
        return ResultCode.OK;
    }

    @Override
    public String getName() {
        return "help";
    }

    @Override
    public void printUsage(PrintStream out) {
        out.println("usage: " + this.getProgramCallString() + " COMMAND [options...] <command arguments>");
        List<String> commands = this.commandFactory.getKnownCommands();
        out.println("\nCommands:");
        for (String cmd : commands) {
            out.print(" ");
            out.println(cmd);
        }
        out.print("\n");
        out.println("Options:");
        this.parser.printUsage(out);
    }

    @Override
    protected String getProgramCallString() {
        return this.programCallString;
    }

    @Override
    protected String getRequiredArgumentsString() {
        return "";
    }

    static class CommandHelpArguments
    extends GlobalArguments {
        CommandHelpArguments() {
        }
    }
}

