/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.client.api.cli;

import ch.systemsx.cisd.args4j.ExampleMode;
import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.InvalidSessionException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.dss.client.api.cli.AbstractDssCommand;
import ch.systemsx.cisd.openbis.dss.client.api.cli.AbstractExecutor;
import ch.systemsx.cisd.openbis.dss.client.api.cli.CommandPut;
import ch.systemsx.cisd.openbis.dss.client.api.cli.GlobalArguments;
import ch.systemsx.cisd.openbis.dss.client.api.cli.ResultCode;
import ch.systemsx.cisd.openbis.dss.client.api.v1.IDataSetDss;
import ch.systemsx.cisd.openbis.dss.client.api.v1.IDssComponent;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.FileInfoDssBuilder;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.FileInfoDssDTO;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.NewDataSetDTO;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.validation.ValidationError;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.validation.ValidationScriptRunner;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class CommandTestValid
extends AbstractDssCommand<CommandTestValidArguments> {
    CommandTestValid() {
        super(new CommandTestValidArguments());
    }

    @Override
    public ResultCode execute(String[] args) throws UserFailureException, EnvironmentFailureException {
        return new CommandTestValidExecutor((CommandTestValidArguments)this.arguments, this).execute(args);
    }

    @Override
    public String getName() {
        return "testvalid";
    }

    @Override
    public void printUsage(PrintStream out) {
        out.println(this.getUsagePrefixString() + " [options] " + this.getRequiredArgumentsString());
        this.parser.printUsage(out);
        out.println("  Examples : ");
        out.println("     " + this.getCommandCallString() + this.parser.printExample(ExampleMode.ALL) + " EXPERIMENT <experiment identifier> <path> <script(s)>");
        out.println("     " + this.getCommandCallString() + this.parser.printExample(ExampleMode.ALL) + " SAMPLE <sample identifier> <path> <script(s)>");
    }

    @Override
    protected String getRequiredArgumentsString() {
        return "<owner type> <owner> <path> [<script(s)>]";
    }

    @Override
    protected IDssComponent login(GlobalArguments args) {
        if (args.getArguments().size() < 4) {
            return super.login(args);
        }
        IDssComponent component = new IDssComponent(){

            @Override
            public void checkSession() throws InvalidSessionException {
            }

            @Override
            public String getSessionToken() throws IllegalStateException {
                return null;
            }

            @Override
            public IDataSetDss getDataSet(String code) throws IllegalStateException, EnvironmentFailureException {
                return null;
            }

            @Override
            public IDataSetDss putDataSet(NewDataSetDTO newDataset, File dataSetFile) throws IllegalStateException, EnvironmentFailureException {
                return null;
            }

            @Override
            public void putFileToSessionWorkspace(String filePath, InputStream inputStream) throws IOExceptionUnchecked {
            }

            @Override
            public void putFileToSessionWorkspace(String directory, File file) throws IOExceptionUnchecked {
            }

            @Override
            public InputStream getFileFromSessionWorkspace(String filePath) throws IOExceptionUnchecked {
                return null;
            }

            @Override
            public void getFileFromSessionWorkspace(String filePath, File localFile) throws IOExceptionUnchecked {
            }

            @Override
            public boolean deleteSessionWorkspaceFile(String path) {
                return false;
            }

            @Override
            public void logout() {
            }

            @Override
            public List<ValidationError> validateDataSet(NewDataSetDTO newDataset, File dataSetFile) throws IllegalStateException, EnvironmentFailureException {
                return new ArrayList<ValidationError>();
            }

            @Override
            public Map<String, String> extractMetadata(NewDataSetDTO newDataset, File dataSetFile) throws IllegalStateException, EnvironmentFailureException {
                return new HashMap<String, String>();
            }
        };
        return component;
    }

    private static class CommandTestValidExecutor
    extends AbstractExecutor<CommandTestValidArguments> {
        CommandTestValidExecutor(CommandTestValidArguments arguments, AbstractDssCommand<CommandTestValidArguments> command) {
            super(arguments, command);
        }

        @Override
        protected ResultCode doExecute(IDssComponent component) {
            try {
                List<ValidationError> errors;
                NewDataSetDTO newDataSet = this.getNewDataSet();
                if (newDataSet.getFileInfos().isEmpty()) {
                    File file = ((CommandTestValidArguments)this.arguments).getFile();
                    if (!file.exists()) {
                        System.err.println("Data set file does not exist");
                    } else if (!file.isDirectory()) {
                        System.err.println("Must select a directory to upload.");
                    } else {
                        System.err.println("Data set is empty.");
                    }
                    return ResultCode.INVALID_ARGS;
                }
                if (null == ((CommandTestValidArguments)this.arguments).getScriptPathsOrNull()) {
                    errors = component.validateDataSet(newDataSet, ((CommandTestValidArguments)this.arguments).getFile());
                } else {
                    ValidationScriptRunner scriptRunner = ValidationScriptRunner.createValidatorFromScriptPaths(((CommandTestValidArguments)this.arguments).getScriptPathsOrNull(), false);
                    errors = scriptRunner.validate(((CommandTestValidArguments)this.arguments).getFile());
                }
                for (ValidationError error : errors) {
                    System.err.println("ERROR: " + error.getErrorMessage());
                }
                if (errors.size() > 0) {
                    return ResultCode.USER_ERROR;
                }
                System.out.println("OK: DataSet passed validation.");
            }
            catch (IOException e) {
                throw new IOExceptionUnchecked(e);
            }
            return ResultCode.OK;
        }

        private NewDataSetDTO getNewDataSet() throws IOException {
            NewDataSetDTO.DataSetOwnerType ownerType = ((CommandTestValidArguments)this.arguments).getOwnerType();
            String ownerIdentifier = ((CommandTestValidArguments)this.arguments).getOwnerIdentifier();
            NewDataSetDTO.DataSetOwner owner = new NewDataSetDTO.DataSetOwner(ownerType, ownerIdentifier);
            File file = ((CommandTestValidArguments)this.arguments).getFile();
            ArrayList<FileInfoDssDTO> fileInfos = this.getFileInfosForPath(file);
            String parentNameOrNull = null;
            if (file.isDirectory()) {
                parentNameOrNull = file.getName();
            }
            NewDataSetDTO dataSet = new NewDataSetDTO(owner, parentNameOrNull, fileInfos);
            dataSet.setDataSetTypeOrNull(((CommandTestValidArguments)this.arguments).getDataSetType());
            dataSet.setProperties(((CommandTestValidArguments)this.arguments).getProperties());
            return dataSet;
        }

        private ArrayList<FileInfoDssDTO> getFileInfosForPath(File file) throws IOException {
            ArrayList<FileInfoDssDTO> fileInfos = new ArrayList<FileInfoDssDTO>();
            if (!file.exists()) {
                return fileInfos;
            }
            String path = file.getCanonicalPath();
            if (!file.isDirectory()) {
                path = file.getParentFile().getCanonicalPath();
            }
            FileInfoDssBuilder builder = new FileInfoDssBuilder(path, path);
            builder.appendFileInfosForFile(file, fileInfos, true);
            return fileInfos;
        }
    }

    static class CommandTestValidArguments
    extends CommandPut.CommandPutArguments {
        CommandTestValidArguments() {
        }

        public String[] getScriptPathsOrNull() {
            if (this.arguments.size() > 3) {
                String[] paths = new String[this.arguments.size() - 3];
                for (int i = 3; i < this.arguments.size(); ++i) {
                    paths[i - 3] = (String)this.arguments.get(i);
                }
                return paths;
            }
            return null;
        }

        @Override
        public boolean allAdditionalMandatoryArgumentsPresent() {
            try {
                String[] paths = this.getScriptPathsOrNull();
                if (null == paths) {
                    return false;
                }
                for (String path : paths) {
                    File scriptFile = new File(path);
                    if (scriptFile.exists()) continue;
                    System.err.println("\n" + path + " does not exist. Please specify a python (jython) script(s).");
                    return false;
                }
            }
            catch (Exception e) {
                System.err.println("\nThe script(s) must be a valid python (jython) script(s).");
            }
            return true;
        }
    }
}

