/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.client.api.gui;

import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.dss.client.api.gui.UiUtilities;
import ch.systemsx.cisd.openbis.dss.client.api.gui.VocabularyTermsComboBoxPanel;
import ch.systemsx.cisd.openbis.dss.client.api.gui.model.DataSetUploadClientModel;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.NewDataSetDTOBuilder;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.NewDataSetMetadataDTO;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.validation.ValidationError;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.ControlledVocabularyPropertyType;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.PropertyTypeGroup;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.VocabularyTerm;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DataSetPropertiesPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final DataSetType dataSetType;
    private final DataSetUploadClientModel clientModel;
    private final HashMap<String, JComponent> formFields = new HashMap();
    private final HashMap<String, JLabel> labels = new HashMap();
    private final LinkedList<Observer> observers = new LinkedList();
    private DataSetUploadClientModel.NewDataSetInfo newDataSetInfo;

    public DataSetPropertiesPanel(DataSetType dataSetType, DataSetUploadClientModel clientModel) {
        this.dataSetType = dataSetType;
        this.clientModel = clientModel;
        this.setLayout(new GridBagLayout());
        this.createGui();
    }

    public DataSetUploadClientModel.NewDataSetInfo getDataSetInfo() {
        return this.newDataSetInfo;
    }

    public void setNewDataSetInfo(DataSetUploadClientModel.NewDataSetInfo dataSetInfo) {
        this.newDataSetInfo = dataSetInfo;
        this.syncGui();
    }

    protected List<JComponent> getAllEditableWidgets() {
        ArrayList<JComponent> editableWidgets = new ArrayList<JComponent>(this.formFields.values());
        return editableWidgets;
    }

    private void createGui() {
        int row = 0;
        int col = 0;
        List<PropertyTypeGroup> groups = this.dataSetType.getPropertyTypeGroups();
        for (PropertyTypeGroup group : groups) {
            for (PropertyType propertyType : group.getPropertyTypes()) {
                this.addFormFieldForPropertyType(row, col, propertyType);
                if (++col <= 1) continue;
                ++row;
                col = 0;
            }
        }
    }

    private void addFormFieldForPropertyType(int row, int col, PropertyType propertyType) {
        String labelString = this.getLabelStringForPropertyType(propertyType);
        JLabel label = new JLabel(labelString + ":", 11);
        label.setPreferredSize(new Dimension(110, 30));
        label.setToolTipText(propertyType.getDescription());
        if (propertyType.isMandatory()) {
            label.setFont(label.getFont().deriveFont(3));
        }
        JComponent formField = propertyType instanceof ControlledVocabularyPropertyType ? this.createComboBox((ControlledVocabularyPropertyType)propertyType) : (propertyType.getDataType() == DataTypeCode.BOOLEAN ? this.createCheckBox(propertyType) : this.createTextField(propertyType));
        formField.setToolTipText(propertyType.getDescription());
        formField.setPreferredSize(new Dimension(120, 30));
        this.addFormField(col, row, label, formField);
        this.labels.put(propertyType.getCode(), label);
        this.formFields.put(propertyType.getCode(), formField);
    }

    private JTextField createTextField(final PropertyType propertyType) {
        final JTextField textField = new JTextField();
        class FieldListener
        implements ActionListener,
        FocusListener {
            FieldListener() {
            }

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                this.handleEvent();
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.handleEvent();
            }

            private void handleEvent() {
                String oldValue;
                String newValue = StringUtils.toStringEmptyIfNull(textField.getText());
                if (!newValue.equals(oldValue = StringUtils.toStringEmptyIfNull(DataSetPropertiesPanel.this.setPropertyValue(propertyType, newValue)))) {
                    DataSetPropertiesPanel.this.notifyObservers();
                }
            }
        }
        FieldListener listener = new FieldListener();
        textField.addActionListener(listener);
        textField.addFocusListener(listener);
        return textField;
    }

    private VocabularyTermsComboBoxPanel createComboBox(final ControlledVocabularyPropertyType propertyType) {
        VocabularyTermsComboBoxPanel comboBox = new VocabularyTermsComboBoxPanel(propertyType, this.clientModel);
        this.clientModel.registerObserver(comboBox);
        comboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DataSetPropertiesPanel.this.setPropertyValue(propertyType, ((VocabularyTerm)e.getItem()).getCode());
                DataSetPropertiesPanel.this.notifyObservers();
            }
        });
        return comboBox;
    }

    private JComponent createCheckBox(final PropertyType propertyType) {
        final JCheckBox checkBox = new JCheckBox();
        checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataSetPropertiesPanel.this.setPropertyValue(propertyType, checkBox.isSelected() ? PropertyUtils.Boolean.TRUE.toString() : PropertyUtils.Boolean.FALSE.toString());
                DataSetPropertiesPanel.this.notifyObservers();
            }
        });
        return checkBox;
    }

    private String getLabelStringForPropertyType(PropertyType propertyType) {
        StringBuilder label = new StringBuilder();
        label.append(propertyType.getLabel());
        if (propertyType.isMandatory()) {
            label.append("*");
        }
        return label.toString();
    }

    private void addFormField(int colx, int rowy, Component label, Component field) {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = colx * 2;
        c.gridy = rowy;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(rowy > 0 ? 5 : 0, 0, 0, 5);
        this.add(label, c);
        ++c.gridx;
        c.weightx = 0.5;
        c.insets = new Insets(rowy > 0 ? 5 : 0, 0, 0, 5);
        this.add(field, c);
    }

    private String setPropertyValue(PropertyType propertyType, String text) {
        if (null == this.newDataSetInfo) {
            return null;
        }
        NewDataSetDTOBuilder builder = this.newDataSetInfo.getNewDataSetBuilder();
        NewDataSetMetadataDTO metadata = builder.getDataSetMetadata();
        Map<String, String> props = metadata.getProperties();
        HashMap<String, String> newProps = new HashMap<String, String>(props);
        String oldValue = null == text || text.trim().length() < 1 ? newProps.remove(propertyType.getCode()) : newProps.put(propertyType.getCode(), text);
        metadata.setProperties(newProps);
        this.clientModel.validateNewDataSetInfoAndNotifyObservers(this.newDataSetInfo);
        this.syncErrors();
        this.clientModel.notifyObserversOfChanges(this.newDataSetInfo);
        return oldValue;
    }

    private void syncGui() {
        NewDataSetDTOBuilder builder = this.newDataSetInfo.getNewDataSetBuilder();
        NewDataSetMetadataDTO metadata = builder.getDataSetMetadata();
        Map<String, String> props = metadata.getProperties();
        for (String propertyTypeCode : this.formFields.keySet()) {
            String propertyValue = props.get(propertyTypeCode);
            JComponent formField = this.formFields.get(propertyTypeCode);
            formField.setEnabled(false == metadata.isUnmodifiableProperty(propertyTypeCode));
            if (formField instanceof JTextField) {
                JTextField textField = (JTextField)formField;
                textField.setText(propertyValue);
                continue;
            }
            if (formField instanceof VocabularyTermsComboBoxPanel) {
                VocabularyTermsComboBoxPanel comboBox = (VocabularyTermsComboBoxPanel)formField;
                for (int i = 0; i < comboBox.getItemCount(); ++i) {
                    VocabularyTerm term = comboBox.getItemAt(i);
                    if (!term.getCode().equals(propertyValue)) continue;
                    comboBox.setSelectedIndex(i);
                }
                continue;
            }
            if (!(formField instanceof JCheckBox)) continue;
            JCheckBox checkBox = (JCheckBox)formField;
            checkBox.setSelected(Boolean.parseBoolean(propertyValue));
        }
    }

    public void syncErrors() {
        for (String key : this.labels.keySet()) {
            this.clearError(this.labels.get(key), this.formFields.get(key));
        }
        List<ValidationError> errors = this.newDataSetInfo.getValidationErrors();
        for (ValidationError error : errors) {
            switch (error.getTarget()) {
                case DATA_SET_OWNER: {
                    break;
                }
                case DATA_SET_TYPE: {
                    break;
                }
                case DATA_SET_FILE: {
                    break;
                }
                case DATA_SET_PROPERTY: {
                    JLabel label = this.labels.get(error.getPropertyCodeOrNull());
                    JComponent formField = this.formFields.get(error.getPropertyCodeOrNull());
                    this.displayError(label, formField, error);
                }
            }
        }
    }

    private void displayError(JLabel label, JComponent component, ValidationError error) {
        if (null == label || null == component) {
            return;
        }
        UiUtilities.displayError(label, component, null, error);
    }

    private void clearError(JLabel label, JComponent component) {
        UiUtilities.clearError(label, component, null);
        component.setToolTipText(label.getToolTipText());
    }

    public void registerObserver(Observer observer) {
        this.observers.add(observer);
    }

    private void notifyObservers() {
        for (Observer observer : this.observers) {
            observer.update();
        }
    }

    public static interface Observer {
        public void update();
    }
}

