/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.client.api.gui;

import ch.systemsx.cisd.openbis.dss.client.api.gui.AbstractEntityPickerDialog;
import ch.systemsx.cisd.openbis.dss.client.api.gui.model.DataSetUploadClientModel;
import ch.systemsx.cisd.openbis.dss.client.api.gui.model.SortableFilterableTableModel;
import ch.systemsx.cisd.openbis.dss.client.api.gui.table.SortButtonRenderer;
import ch.systemsx.cisd.openbis.dss.client.api.gui.table.TableHeaderMouseListener;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifierFactory;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.JTableHeader;

public class ExperimentPickerDialog
extends AbstractEntityPickerDialog {
    private static final long serialVersionUID = 6688336042860619854L;
    private static String[] HEADERS = new String[]{"Space code", "Project code", "Experiment code", "Experiment identifier"};
    private final JTable table = ExperimentPickerDialog.createTable();
    private final JTextField filterField = ExperimentPickerDialog.createFilterField(this.table);
    private final JOptionPane optionPane;

    public ExperimentPickerDialog(JFrame mainWindow, DataSetUploadClientModel clientModel) {
        super(mainWindow, "Pick an experiment", clientModel);
        JPanel northPanel = ExperimentPickerDialog.createFilterAndRefreshButtonPanel(this.filterField, this.refreshButton);
        this.optionPane = ExperimentPickerDialog.createOptionPane(northPanel, this.table, this);
        ExperimentPickerDialog.createTableListener(this.table, this.optionPane);
        this.setDialogData();
        this.setContentPane(this.optionPane);
    }

    private static JOptionPane createOptionPane(JPanel northPanel, final JTable table, final JDialog parent) {
        JScrollPane scrollPane = new JScrollPane(table);
        Object[] objects = new Object[]{"Filter experiments: ", northPanel, "Select Experiment:", scrollPane};
        final JOptionPane optionPane = new JOptionPane(objects, -1, 2);
        optionPane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("value") && evt.getNewValue() != null) {
                    if ((Integer)evt.getNewValue() == 0 && table.getSelectedRow() == -1) {
                        JOptionPane.showMessageDialog(parent, "Experiment needs to be selected!", "No experiment selected!", 2);
                        optionPane.setValue(optionPane.getInitialValue());
                    } else {
                        parent.setVisible(false);
                    }
                }
            }
        });
        return optionPane;
    }

    private static List<String[]> prepareData(List<Experiment> experiments) {
        ArrayList<String[]> data = new ArrayList<String[]>(experiments.size());
        for (Experiment experiment : experiments) {
            ExperimentIdentifier expId = ExperimentIdentifierFactory.parse(experiment.getIdentifier());
            data.add(new String[]{expId.getSpaceCode(), expId.getProjectCode(), expId.getExperimentCode(), experiment.getIdentifier()});
        }
        return data;
    }

    private static JTable createTable() {
        JTable table = new JTable();
        table.setPreferredScrollableViewportSize(new Dimension(500, 150));
        table.setSelectionMode(0);
        JTableHeader header = table.getTableHeader();
        for (int i = 0; i < table.getColumnModel().getColumnCount() - 1; ++i) {
            table.getColumnModel().getColumn(i).setPreferredWidth(110);
        }
        header.setDefaultRenderer(new SortButtonRenderer());
        return table;
    }

    private static void createTableListener(final JTable table, final JOptionPane optionPane) {
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && table.getSelectedRow() != -1) {
                    optionPane.setValue(0);
                }
            }
        });
    }

    private static JTextField createFilterField(final JTable table) {
        final JTextField filterField = new JTextField();
        filterField.setEditable(true);
        filterField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                SortableFilterableTableModel model = (SortableFilterableTableModel)table.getModel();
                model.filter(filterField.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SortableFilterableTableModel model = (SortableFilterableTableModel)table.getModel();
                model.filter(filterField.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SortableFilterableTableModel model = (SortableFilterableTableModel)table.getModel();
                model.filter(filterField.getText());
            }
        });
        return filterField;
    }

    @Override
    protected void setDialogData() {
        List<Experiment> experiments = this.clientModel.getExperiments();
        SortableFilterableTableModel model = new SortableFilterableTableModel(ExperimentPickerDialog.prepareData(experiments), HEADERS);
        this.table.setModel(model);
        this.table.getTableHeader().addMouseListener(new TableHeaderMouseListener(model));
        model.filter(this.filterField.getText());
        this.table.getColumnModel().getColumn(3).setPreferredWidth(200);
    }

    public String pickExperiment() {
        this.pack();
        int height = this.getHeight() > 500 ? 500 : this.getHeight();
        int width = this.getWidth() > 600 ? 600 : this.getWidth();
        this.setSize(width, height);
        Point mwLocation = this.mainWindow.getLocationOnScreen();
        int x = mwLocation.x + this.mainWindow.getWidth() / 2 - this.getWidth() / 2;
        int y = mwLocation.y + this.mainWindow.getHeight() / 2 - this.getHeight() / 2;
        this.setLocation(x > 0 ? x : 0, y > 0 ? y : 0);
        this.setVisible(true);
        Object value = this.optionPane.getValue();
        this.optionPane.setValue(this.optionPane.getInitialValue());
        if (value == null || (Integer)value == 2) {
            return null;
        }
        return this.table.getValueAt(this.table.getSelectedRow(), 3).toString();
    }
}

