/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.client.api.gui;

import ch.systemsx.cisd.openbis.dss.client.api.gui.model.DataSetUploadClientModel;
import ch.systemsx.cisd.openbis.dss.client.api.gui.model.DataSetUploadTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class UploadStatusTableCellRenderer
implements TableCellRenderer {
    private final JButton uploadButton = new JButton("Upload");
    private final JPanel uploadPanel = new JPanel();
    private final JLabel fixErrorsLabel = new JLabel("<html>Incomplete<br>(see fields in red)</html>");
    private final JPanel fixErrorsPanel = new JPanel();
    private final JProgressBar progressBar = new JProgressBar(0, 100);
    private final JLabel progressLabel = new JLabel();
    private final JPanel progressPanel = new JPanel();
    private final JButton retryButton = new JButton("Retry Upload");
    private final JLabel retryLabel = new JLabel("<html><i>Upload Failed</i></html>");
    private final JPanel retryPanel = new JPanel();
    private final JLabel completedLabel = new JLabel("Registered");
    private final JPanel completedPanel = new JPanel();

    public UploadStatusTableCellRenderer(DataSetUploadTableModel tableModel) {
        this.createFixErrorsPanel();
        this.createDownloadPanel();
        this.createProgressPanel();
        this.createRetryPanel();
        this.createCompletedPanel();
    }

    private void createFixErrorsPanel() {
        this.fixErrorsPanel.setLayout(new GridLayout(1, 0));
        this.fixErrorsLabel.setFont(this.fixErrorsLabel.getFont().deriveFont(0));
        this.fixErrorsLabel.setForeground(Color.RED);
        this.fixErrorsLabel.setToolTipText("Fields marked in red have not been specified correctly. Place the mouse over the field for a description of the error.");
        this.fixErrorsPanel.add(this.fixErrorsLabel);
        this.fixErrorsPanel.setOpaque(true);
    }

    private void createCompletedPanel() {
        this.completedPanel.setLayout(new GridLayout(1, 0));
        this.completedLabel.setFont(this.completedLabel.getFont().deriveFont(0));
        this.completedPanel.add(this.completedLabel);
        this.completedPanel.setOpaque(true);
    }

    private void createRetryPanel() {
        this.retryPanel.setLayout(new GridLayout(2, 0));
        this.retryLabel.setFont(this.retryLabel.getFont().deriveFont(0));
        this.retryPanel.add(this.retryLabel);
        this.retryPanel.add(this.retryButton);
        this.retryPanel.setOpaque(true);
    }

    private void createProgressPanel() {
        this.progressPanel.setLayout(new GridLayout(2, 0));
        this.progressPanel.add(this.progressBar);
        this.progressLabel.setFont(this.progressLabel.getFont().deriveFont(0));
        this.progressPanel.add(this.progressLabel);
        this.progressPanel.setOpaque(true);
    }

    private void createDownloadPanel() {
        this.uploadPanel.setLayout(new GridLayout(1, 0));
        this.uploadPanel.add(this.uploadButton);
        this.uploadPanel.setOpaque(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JPanel panel;
        Color backgroundColor = isSelected ? table.getSelectionBackground() : table.getBackground();
        DataSetUploadClientModel.NewDataSetInfo dataSetInfo = (DataSetUploadClientModel.NewDataSetInfo)value;
        switch (dataSetInfo.getStatus()) {
            case TO_UPLOAD: {
                if (dataSetInfo.hasErrors()) {
                    panel = this.fixErrorsPanel;
                    break;
                }
                panel = this.uploadPanel;
                break;
            }
            case QUEUED_FOR_UPLOAD: 
            case UPLOADING: {
                panel = this.progressPanel;
                this.progressBar.setValue(dataSetInfo.getPercentageDownloaded());
                break;
            }
            case STALLED: {
                panel = this.progressPanel;
                this.progressBar.setValue(0);
                this.progressLabel.setText("uploading...");
                break;
            }
            case COMPLETED_UPLOAD: {
                panel = this.completedPanel;
                break;
            }
            case FAILED: {
                panel = this.retryPanel;
                break;
            }
            default: {
                throw new RuntimeException("Unknown status ");
            }
        }
        panel.setBackground(backgroundColor);
        return panel;
    }
}

