/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.client.api.gui.model;

import ch.systemsx.cisd.openbis.dss.client.api.gui.model.DataSetUploadClientModel;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.NewDataSetDTO;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.NewDataSetDTOBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.table.AbstractTableModel;

public class DataSetUploadTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    public static final int DATA_SET_OWNER_COLUMN = 0;
    public static final int DATA_SET_TYPE_COLUMN = 1;
    public static final int DATA_SET_METADATA_COLUMN = 2;
    public static final int DATA_SET_PATH_COLUMN = 3;
    public static final int UPLOAD_STATUS_COLUMN = 4;
    private final DataSetUploadClientModel clientModel;
    private final ArrayList<DataSetUploadClientModel.NewDataSetInfo> newDataSetInfos = new ArrayList();
    private int sortColumnIndex = 0;
    private boolean sortAscending = true;
    private int selectedRow = -1;
    private ISynchronizer synchronizer;

    public DataSetUploadTableModel(DataSetUploadClientModel clientModel) {
        this.clientModel = clientModel;
    }

    public void setSynchronizer(ISynchronizer synchronizer) {
        this.synchronizer = synchronizer;
    }

    void fireChanged(DataSetUploadClientModel.NewDataSetInfo newDataSetInfo, DataSetUploadClientModel.NewDataSetInfo.Status newStatus) {
        int index = this.newDataSetInfos.indexOf(newDataSetInfo);
        this.fireTableRowsUpdated(index, index);
    }

    public void setSelectedIndices(ArrayList<Integer> selectedIndices) {
        if (selectedIndices.size() < 1) {
            this.selectNewDataSetInfo(null);
            return;
        }
        this.selectedRow = selectedIndices.get(0);
        DataSetUploadClientModel.NewDataSetInfo selectedDataSet = this.getSelectedNewDataSetOrNull();
        this.selectNewDataSetInfo(selectedDataSet);
    }

    public int getSortColumnIndex() {
        return this.sortColumnIndex;
    }

    public void setSortColumnIndex(int sortColumnIndex) {
        this.sortColumnIndex = sortColumnIndex;
    }

    public boolean isSortAscending() {
        return this.sortAscending;
    }

    public void setSortAscending(boolean sortAscending) {
        this.sortAscending = sortAscending;
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public int getRowCount() {
        return this.newDataSetInfos.size();
    }

    @Override
    public String getColumnName(int columnIndex) {
        String name = "";
        if (columnIndex == this.sortColumnIndex) {
            name = this.sortAscending ? "\u25b2" : "\u25bc";
        }
        switch (columnIndex) {
            case 0: {
                name = name + " Owner";
                break;
            }
            case 1: {
                name = name + " Type";
                break;
            }
            case 2: {
                name = name + " Metadata";
                break;
            }
            case 3: {
                name = name + " Path";
                break;
            }
        }
        return name;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        DataSetUploadClientModel.NewDataSetInfo newDataSetInfo = this.newDataSetInfos.get(rowIndex);
        NewDataSetDTOBuilder builder = newDataSetInfo.getNewDataSetBuilder();
        switch (columnIndex) {
            case 0: {
                NewDataSetDTO.DataSetOwner owner = builder.getDataSetOwner();
                return (Object)((Object)owner.getType()) + ":" + this.untouchedStringOrEmpty(owner.getIdentifier());
            }
            case 1: {
                return this.untouchedStringOrEmpty(builder.getDataSetMetadata().tryDataSetType());
            }
            case 2: {
                return builder.getDataSetMetadata().getProperties();
            }
            case 3: {
                File file = builder.getFile();
                return file == null ? "" : file.getName();
            }
            case 4: {
                return newDataSetInfo;
            }
        }
        return null;
    }

    private String untouchedStringOrEmpty(String aString) {
        return aString == null ? "" : aString;
    }

    @Override
    public Class<?> getColumnClass(int c) {
        Object columnValue = this.getValueAt(0, c);
        if (columnValue == null) {
            return super.getColumnClass(c);
        }
        return columnValue.getClass();
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        assert (col == 4);
        DataSetUploadClientModel.NewDataSetInfo newDataSetInfo = (DataSetUploadClientModel.NewDataSetInfo)value;
        if (null == newDataSetInfo) {
            return;
        }
        DataSetUploadClientModel.NewDataSetInfo.Status status = newDataSetInfo.getStatus();
        if (status != DataSetUploadClientModel.NewDataSetInfo.Status.TO_UPLOAD && status != DataSetUploadClientModel.NewDataSetInfo.Status.FAILED) {
            return;
        }
        this.queueUploadOfDataSet(newDataSetInfo);
        this.fireTableCellUpdated(row, col);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex != 4) {
            return false;
        }
        DataSetUploadClientModel.NewDataSetInfo newDataSetInfo = this.newDataSetInfos.get(rowIndex);
        if (null == newDataSetInfo) {
            return false;
        }
        DataSetUploadClientModel.NewDataSetInfo.Status status = newDataSetInfo.getStatus();
        return status == DataSetUploadClientModel.NewDataSetInfo.Status.TO_UPLOAD || status == DataSetUploadClientModel.NewDataSetInfo.Status.FAILED || status == DataSetUploadClientModel.NewDataSetInfo.Status.COMPLETED_UPLOAD;
    }

    public void selectedRowDataChanged() {
        if (this.selectedRow < 0) {
            return;
        }
        this.fireTableRowsUpdated(this.selectedRow, this.selectedRow);
    }

    public void addNewDataSet() {
        DataSetUploadClientModel.NewDataSetInfo newlyCreated = this.clientModel.addNewDataSetInfo(this.getSelectedNewDataSetOrNull());
        this.syncNewDataSetInfos();
        ArrayList<Integer> selectedIndices = new ArrayList<Integer>();
        selectedIndices.add(this.clientModel.getNewDataSetInfos().size() - 1);
        this.setSelectedIndices(selectedIndices);
        this.selectNewDataSetInfo(newlyCreated);
        this.synchronizer.selectRow(selectedIndices.get(0));
    }

    public void removeSelectedDataSet() {
        if (this.selectedRow < 0) {
            return;
        }
        if (this.selectedRow >= this.newDataSetInfos.size()) {
            return;
        }
        DataSetUploadClientModel.NewDataSetInfo dataSetInfoToRemove = this.getSelectedNewDataSetOrNull();
        int newSelectedRow = -1;
        ArrayList<Integer> selectedIndices = new ArrayList<Integer>();
        selectedIndices.add(newSelectedRow);
        this.setSelectedIndices(selectedIndices);
        this.clientModel.removeNewDataSetInfo(dataSetInfoToRemove);
        this.syncNewDataSetInfos();
    }

    private void syncNewDataSetInfos() {
        this.newDataSetInfos.clear();
        this.newDataSetInfos.addAll(this.clientModel.getNewDataSetInfos());
        this.syncNewDataSetInfoListView();
    }

    public void syncNewDataSetInfoListView() {
        Collections.sort(this.newDataSetInfos, new NewDataSetInfoComparator());
        this.synchronizer.tableChanged(this);
    }

    private void selectNewDataSetInfo(DataSetUploadClientModel.NewDataSetInfo newDataSetInfo) {
        this.synchronizer.setNewDataSetInfo(newDataSetInfo);
    }

    private void queueUploadOfDataSet(DataSetUploadClientModel.NewDataSetInfo newDataSetInfo) {
        this.clientModel.queueUploadOfDataSet(newDataSetInfo);
    }

    public DataSetUploadClientModel.NewDataSetInfo getSelectedNewDataSetOrNull() {
        return this.selectedRow < 0 ? null : this.newDataSetInfos.get(this.selectedRow);
    }

    private class NewDataSetInfoComparator
    implements Comparator<DataSetUploadClientModel.NewDataSetInfo> {
        private NewDataSetInfoComparator() {
        }

        @Override
        public int compare(DataSetUploadClientModel.NewDataSetInfo info1, DataSetUploadClientModel.NewDataSetInfo info2) {
            int result = 0;
            switch (DataSetUploadTableModel.this.sortColumnIndex) {
                case 0: {
                    String identifier1 = info1.getNewDataSetBuilder().getDataSetOwnerIdentifier();
                    String identifier2 = info2.getNewDataSetBuilder().getDataSetOwnerIdentifier();
                    result = identifier1.compareTo(identifier2);
                    break;
                }
                case 1: {
                    String type1 = info1.getNewDataSetBuilder().getDataSetMetadata().tryDataSetType();
                    String type2 = info2.getNewDataSetBuilder().getDataSetMetadata().tryDataSetType();
                    type1 = null == type1 ? "" : type1;
                    type2 = null == type2 ? "" : type2;
                    result = type1.compareTo(type2);
                    break;
                }
                case 3: {
                    File file1 = info1.getNewDataSetBuilder().getFile();
                    File file2 = info2.getNewDataSetBuilder().getFile();
                    String path1 = null != file1 ? file1.getAbsolutePath() : "";
                    String path2 = null != file2 ? file2.getAbsolutePath() : "";
                    result = path1.compareTo(path2);
                    break;
                }
                case 4: {
                    result = info1.getStatus().compareTo(info2.getStatus());
                }
            }
            return DataSetUploadTableModel.this.sortAscending ? result : -result;
        }
    }

    public static interface ISynchronizer {
        public void selectRow(int var1);

        public void setNewDataSetInfo(DataSetUploadClientModel.NewDataSetInfo var1);

        public void tableChanged(DataSetUploadTableModel var1);
    }
}

