/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.client.api.gui.model;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.dss.client.api.v1.IOpenbisServiceFacade;
import ch.systemsx.cisd.openbis.dss.client.api.v1.OpenbisServiceFacadeFactory;
import ch.systemsx.cisd.openbis.dss.client.api.v3.IOpenbisServiceFacadeV3;
import ch.systemsx.cisd.openbis.dss.client.api.v3.OpenbisServiceFacadeV3;

public class DssCommunicationState {
    private final IOpenbisServiceFacade openBISService;
    private final IOpenbisServiceFacadeV3 serviceFacadeV3;
    private final boolean logoutOnClose;
    private static final long CONNECTION_TIMEOUT_MILLIS = 60000L;

    public DssCommunicationState(String[] args) throws UserFailureException, EnvironmentFailureException {
        if (args.length < 2) {
            throw new ConfigurationFailureException("The openBIS File Upload Client was improperly configured -- the arguments it requires were not supplied. Please talk to the openBIS administrator.");
        }
        String openBisUrl = args[0];
        switch (args.length) {
            case 2: {
                String sessionToken = args[1];
                this.serviceFacadeV3 = OpenbisServiceFacadeV3.tryCreate(sessionToken, openBisUrl, 60000L);
                if (null == this.serviceFacadeV3) {
                    throw new ConfigurationFailureException("The openBIS File Upload Client was improperly configured -- the session token is not valid. Please talk to the openBIS administrator.");
                }
                this.openBISService = OpenbisServiceFacadeFactory.tryCreate(sessionToken, openBisUrl, 60000L);
                this.logoutOnClose = false;
                break;
            }
            default: {
                String userName = args[1];
                String passwd = args[2];
                this.serviceFacadeV3 = OpenbisServiceFacadeV3.tryCreate(userName, passwd, openBisUrl, 60000L);
                if (null == this.serviceFacadeV3) {
                    throw new ConfigurationFailureException("The user name / password combination is incorrect.");
                }
                String token = this.serviceFacadeV3.getSessionToken();
                this.openBISService = OpenbisServiceFacadeFactory.tryCreate(token, openBisUrl, 60000L);
                this.logoutOnClose = true;
            }
        }
    }

    public IOpenbisServiceFacade getOpenBISService() {
        return this.openBISService;
    }

    public IOpenbisServiceFacadeV3 getServiceFacadeV3() {
        return this.serviceFacadeV3;
    }

    public boolean isLogoutOnClose() {
        return this.logoutOnClose;
    }
}

