/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.client.api.gui.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.table.AbstractTableModel;

public class SortableFilterableTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -7363632554479395042L;
    private int sortByColumn = -1;
    private Direction sortingOrder = Direction.ASC;
    private final String[] headers;
    private final List<String[]> data;
    private List<String[]> viewData;
    private String filter = "";

    public SortableFilterableTableModel(List<String[]> data, String[] headers) {
        this.data = data;
        this.headers = headers;
    }

    @Override
    public String getColumnName(int col) {
        return this.headers[col];
    }

    @Override
    public int getRowCount() {
        if (this.viewData != null) {
            return this.viewData.size();
        }
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return this.headers.length;
    }

    public void filter(String filter) {
        Pattern pattern;
        this.filter = "(?i)" + filter;
        try {
            pattern = Pattern.compile(this.filter);
        }
        catch (RuntimeException e) {
            pattern = Pattern.compile(".*");
        }
        this.viewData = new ArrayList<String[]>();
        block2: for (String[] row : this.data) {
            boolean matches = false;
            for (String value : row) {
                boolean bl = matches = matches || pattern.matcher(value).find();
                if (!matches) continue;
                this.viewData.add(row);
                continue block2;
            }
        }
        if (this.sortByColumn > -1) {
            Collections.sort(this.viewData, new RowComparator(this.sortByColumn, Direction.ASC != this.sortingOrder));
        }
        this.fireTableDataChanged();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.viewData != null) {
            return this.viewData.get(rowIndex)[columnIndex];
        }
        return this.data.get(rowIndex)[columnIndex];
    }

    public boolean isAscending(int column) {
        return Direction.ASC == this.sortingOrder;
    }

    public boolean isSorting(int column) {
        return column == this.sortByColumn;
    }

    public synchronized void toggleSort(int column) {
        if (column == this.sortByColumn) {
            switch (this.sortingOrder) {
                case ASC: {
                    this.sortingOrder = Direction.DESC;
                    break;
                }
                case DESC: {
                    this.sortByColumn = -1;
                }
            }
        } else {
            this.sortByColumn = column;
            this.sortingOrder = Direction.ASC;
        }
        this.filter(this.filter);
    }

    private static class RowComparator
    implements Comparator<String[]> {
        private final int columnNumber;
        private final boolean reverse;

        private RowComparator(int columnNumber, boolean reverse) {
            this.columnNumber = columnNumber;
            this.reverse = reverse;
        }

        @Override
        public int compare(String[] o1, String[] o2) {
            if (this.reverse) {
                return -o1[this.columnNumber].compareTo(o2[this.columnNumber]);
            }
            return o1[this.columnNumber].compareTo(o2[this.columnNumber]);
        }
    }

    private static enum Direction {
        ASC,
        DESC;

    }
}

