/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.client.api.gui.tree;

import ch.systemsx.cisd.openbis.dss.client.api.gui.UiUtilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.regex.Pattern;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class FilterableMutableTreeNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = 1L;
    private Pattern pattern = Pattern.compile(".*");
    private ArrayList<Object> filtered = new ArrayList();

    public FilterableMutableTreeNode(Object nodeValue) {
        super(nodeValue);
        this.filter(".*");
    }

    private synchronized Pattern getPattern() {
        return this.pattern;
    }

    private synchronized void setPattern(Pattern pattern) {
        this.pattern = pattern;
        this.filter(pattern);
    }

    private synchronized ArrayList<Object> getFiltered() {
        return this.filtered;
    }

    private synchronized void setFiltered(ArrayList<Object> filtered) {
        this.filtered = filtered;
    }

    public void filter(String filter) {
        Pattern pattern;
        try {
            pattern = Pattern.compile("(?i)" + filter);
        }
        catch (RuntimeException e) {
            pattern = Pattern.compile(".*");
        }
        this.setPattern(pattern);
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            ((FilterableMutableTreeNode)this.getChildAt(i)).setPattern(pattern);
        }
    }

    private void filter(Pattern pattern) {
        ArrayList<Object> filtered = new ArrayList<Object>();
        Enumeration<TreeNode> enumeration = super.children();
        while (enumeration.hasMoreElements()) {
            TreeNode o = enumeration.nextElement();
            if (!UiUtilities.isMatchingNode(o, pattern)) continue;
            filtered.add(o);
        }
        Collections.sort(filtered, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return String.valueOf(o1).compareTo(String.valueOf(o2));
            }
        });
        this.setFiltered(filtered);
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        ArrayList<Object> filtered = this.getFiltered();
        if (filtered == null) {
            throw new ArrayIndexOutOfBoundsException("node has no children");
        }
        return (TreeNode)filtered.get(childIndex);
    }

    @Override
    public int getChildCount() {
        ArrayList<Object> filtered = this.getFiltered();
        if (filtered == null) {
            return 0;
        }
        return filtered.size();
    }

    @Override
    public int getIndex(TreeNode aChild) {
        if (aChild == null) {
            throw new IllegalArgumentException("argument is null");
        }
        if (!this.isNodeChild(aChild)) {
            return -1;
        }
        return this.getFiltered().indexOf(aChild);
    }

    @Override
    public Enumeration<TreeNode> children() {
        return new FilteredEnumerationWrapper(super.children(), this.getPattern());
    }

    @Override
    public void add(MutableTreeNode o) {
        this.add(o, true);
    }

    public void add(MutableTreeNode o, boolean filter) {
        super.add(o);
        if (o instanceof FilterableMutableTreeNode) {
            FilterableMutableTreeNode filterableMutableTreeNode = (FilterableMutableTreeNode)o;
            filterableMutableTreeNode.setPattern(this.getPattern());
        }
        if (filter) {
            this.filter();
        }
    }

    public void filter() {
        this.filter(this.getPattern());
    }

    @Override
    public void remove(int childIndex) {
        Object removed = this.getFiltered().remove(childIndex);
        if (removed != null) {
            this.children.remove(removed);
        }
    }

    @Override
    public void removeAllChildren() {
        super.removeAllChildren();
        this.filter();
    }

    private static class FilteredEnumerationWrapper
    implements Enumeration<TreeNode> {
        private final Enumeration<TreeNode> enumeration;
        private final Pattern pattern;
        private TreeNode next;

        private FilteredEnumerationWrapper(Enumeration<TreeNode> enumeration, Pattern pattern) {
            this.enumeration = enumeration;
            this.pattern = pattern;
        }

        @Override
        public boolean hasMoreElements() {
            return this.next != null;
        }

        @Override
        public TreeNode nextElement() {
            if (this.next == null) {
                return this.enumeration.nextElement();
            }
            TreeNode ret = this.next;
            this.next = null;
            while (this.enumeration.hasMoreElements()) {
                TreeNode tmp = this.enumeration.nextElement();
                if (!UiUtilities.isMatchingNode(tmp, this.pattern)) continue;
                this.next = tmp;
                break;
            }
            return ret;
        }
    }
}

