/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.client.api.v1.impl;

import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.common.api.IRpcServiceFactory;
import ch.systemsx.cisd.common.exceptions.AuthorizationFailureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.InvalidSessionException;
import ch.systemsx.cisd.openbis.common.api.client.ServiceFinder;
import ch.systemsx.cisd.openbis.dss.client.api.v1.IDataSetDss;
import ch.systemsx.cisd.openbis.dss.client.api.v1.IDssComponent;
import ch.systemsx.cisd.openbis.dss.client.api.v1.impl.AbstractDssComponentState;
import ch.systemsx.cisd.openbis.dss.client.api.v1.impl.AuthenticatedState;
import ch.systemsx.cisd.openbis.dss.client.api.v1.impl.DssServiceRpcFactory;
import ch.systemsx.cisd.openbis.dss.client.api.v1.impl.UnauthenticatedState;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.NewDataSetDTO;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.validation.ValidationError;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.IGeneralInformationService;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

public class DssComponent
implements IDssComponent {
    private final IGeneralInformationService generalOpenBisService;
    private final IRpcServiceFactory dssServiceFactory;
    private AbstractDssComponentState state;

    public static DssComponent tryCreate(String user, String password, String openBISUrl, long timeoutInMillis) {
        DssComponent component = new DssComponent(openBISUrl, null, timeoutInMillis);
        try {
            component.login(user, password);
        }
        catch (AuthorizationFailureException e) {
            return null;
        }
        return component;
    }

    public static DssComponent tryCreate(String sessionToken, String openBISUrl, long timeoutInMillis) {
        DssComponent component = new DssComponent(openBISUrl, sessionToken, timeoutInMillis);
        try {
            component.checkSession();
        }
        catch (InvalidSessionException e) {
            return null;
        }
        return component;
    }

    private static IGeneralInformationService createGeneralInformationService(String openBISURL, long timeoutInMillis) {
        ServiceFinder generalInformationServiceFinder = new ServiceFinder("openbis", "/rmi-general-information-v1");
        IGeneralInformationService service = generalInformationServiceFinder.createService(IGeneralInformationService.class, openBISURL, timeoutInMillis);
        return service;
    }

    private DssComponent(String openBISURL, String sessionTokenOrNull, long timeoutInMillis) {
        this(DssComponent.createGeneralInformationService(openBISURL, timeoutInMillis), new DssServiceRpcFactory(timeoutInMillis), sessionTokenOrNull);
    }

    public DssComponent(IGeneralInformationService service, IRpcServiceFactory dssServiceFactory, String sessionTokenOrNull) {
        this.generalOpenBisService = service;
        this.dssServiceFactory = dssServiceFactory;
        this.state = sessionTokenOrNull == null ? new UnauthenticatedState(service) : new AuthenticatedState(service, dssServiceFactory, sessionTokenOrNull);
    }

    @Override
    public String getSessionToken() {
        return this.state.getSessionToken();
    }

    @Override
    public void checkSession() throws InvalidSessionException {
        this.state.checkSession();
    }

    @Override
    public IDataSetDss getDataSet(String code) throws EnvironmentFailureException, IllegalStateException {
        return this.state.getDataSet(code);
    }

    @Override
    public void logout() {
        this.state.logout();
        this.state = new UnauthenticatedState(this.generalOpenBisService);
    }

    void login(String user, String password) throws AuthorizationFailureException, EnvironmentFailureException {
        this.state.login(user, password);
        this.state = new AuthenticatedState(this.generalOpenBisService, this.dssServiceFactory, this.state.getSessionToken());
    }

    @Override
    public IDataSetDss putDataSet(NewDataSetDTO newDataset, File dataSetFile) throws IllegalStateException, EnvironmentFailureException {
        return this.state.putDataSet(newDataset, dataSetFile);
    }

    @Override
    public void putFileToSessionWorkspace(String filePath, InputStream inputStream) throws IOExceptionUnchecked {
        this.state.putFileToSessionWorkspace(filePath, inputStream);
    }

    @Override
    public void putFileToSessionWorkspace(String directory, File file) throws IOExceptionUnchecked {
        this.state.putFileToSessionWorkspace(directory, file);
    }

    @Override
    public InputStream getFileFromSessionWorkspace(String filePath) throws IOExceptionUnchecked {
        return this.state.getFileFromSessionWorkspace(filePath);
    }

    @Override
    public void getFileFromSessionWorkspace(String filePath, File localFile) throws IOExceptionUnchecked {
        this.state.getFileFromSessionWorkspace(filePath, localFile);
    }

    @Override
    public boolean deleteSessionWorkspaceFile(String path) {
        return this.state.deleteSessionWorkspaceFile(path);
    }

    @Override
    public List<ValidationError> validateDataSet(NewDataSetDTO newDataset, File dataSetFile) throws IllegalStateException, EnvironmentFailureException {
        return this.state.validateDataSet(newDataset, dataSetFile);
    }

    @Override
    public Map<String, String> extractMetadata(NewDataSetDTO newDataset, File dataSetFile) throws IllegalStateException, EnvironmentFailureException {
        return this.state.extractMetadata(newDataset, dataSetFile);
    }
}

