/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.client.api.v3;

import ch.ethz.sis.openbis.generic.asapi.v3.IApplicationServerApi;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.SearchResult;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.Sample;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.fetchoptions.SampleFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.search.SampleSearchCriteria;
import ch.systemsx.cisd.common.api.retry.RetryCaller;
import ch.systemsx.cisd.common.api.retry.RetryProxyFactory;
import ch.systemsx.cisd.openbis.common.api.client.ServiceFinder;
import ch.systemsx.cisd.openbis.dss.client.api.v3.IOpenbisServiceFacadeV3;

public class OpenbisServiceFacadeV3
implements IOpenbisServiceFacadeV3 {
    private String sessionToken;
    private IApplicationServerApi service;

    public static IOpenbisServiceFacadeV3 tryCreate(final String username, final String password, final String openbisUrl, final long timeoutInMillis) {
        RetryCaller<IOpenbisServiceFacadeV3, RuntimeException> caller = new RetryCaller<IOpenbisServiceFacadeV3, RuntimeException>(){

            @Override
            protected IOpenbisServiceFacadeV3 call() {
                IApplicationServerApi service = OpenbisServiceFacadeV3.createService(openbisUrl, timeoutInMillis);
                String sessionToken = service.login(username, password);
                OpenbisServiceFacadeV3 facade = new OpenbisServiceFacadeV3(sessionToken, service);
                return RetryProxyFactory.createProxy(facade);
            }
        };
        return (IOpenbisServiceFacadeV3)caller.callWithRetry();
    }

    public static IOpenbisServiceFacadeV3 tryCreate(final String sessionToken, final String openbisUrl, final long timeoutInMillis) {
        RetryCaller<IOpenbisServiceFacadeV3, RuntimeException> caller = new RetryCaller<IOpenbisServiceFacadeV3, RuntimeException>(){

            @Override
            protected IOpenbisServiceFacadeV3 call() {
                IApplicationServerApi service = OpenbisServiceFacadeV3.createService(openbisUrl, timeoutInMillis);
                OpenbisServiceFacadeV3 facade = new OpenbisServiceFacadeV3(sessionToken, service);
                return RetryProxyFactory.createProxy(facade);
            }
        };
        return (IOpenbisServiceFacadeV3)caller.callWithRetry();
    }

    private static IApplicationServerApi createService(String openbisUrl, long timeoutInMillis) {
        ServiceFinder serviceFinder = new ServiceFinder("openbis", "/rmi-application-server-v3");
        return serviceFinder.createService(IApplicationServerApi.class, openbisUrl, timeoutInMillis);
    }

    private OpenbisServiceFacadeV3(String sessionToken, IApplicationServerApi service) {
        this.sessionToken = sessionToken;
        this.service = service;
    }

    @Override
    public String getSessionToken() {
        return this.sessionToken;
    }

    @Override
    public SearchResult<Sample> searchSamples(SampleSearchCriteria searchCriteria, SampleFetchOptions fetchOptions) {
        return this.service.searchSamples(this.sessionToken, searchCriteria, fetchOptions);
    }
}

