/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared.utils;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.fasta.SequenceType;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.process.ProcessExecutionHelper;
import ch.systemsx.cisd.common.process.ProcessResult;
import ch.systemsx.cisd.openbis.generic.shared.coreplugin.CorePluginScanner;
import ch.systemsx.cisd.openbis.generic.shared.coreplugin.CorePluginsUtils;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.log4j.Logger;

public class BlastUtils {
    public final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, BlastUtils.class);
    private final Logger machineLog = LogFactory.getLogger(LogCategory.MACHINE, BlastUtils.class);
    private static final String[] BLASTN_OPTIONS = new String[]{"task", "evalue", "word_size", "ungapped"};
    private static final String[] BLASTP_OPTIONS = new String[]{"task", "evalue", "word_size"};
    private final String BLAST_ROOT = "eln-lims/bin/blast";
    private final String LINUX = "linux/bin/";
    private final String MAC = "mac/bin/";
    public static final String BLAST_TOOLS_DIRECTORY_PROPERTY = "blast-tools-directory";
    public static final String BLAST_DATABASES_FOLDER_PROPERTY = "blast-databases-folder";
    public static final String DEFAULT_BLAST_DATABASES_FOLDER = "blast-databases";
    private String blastn;
    private String blastp;
    private boolean available;
    private File databaseFolder;

    public BlastUtils(Properties properties, File storeRoot) {
        String blastToolDirectory = this.getBLASTToolDirectory(properties);
        this.blastn = blastToolDirectory + "blastn";
        this.blastp = blastToolDirectory + "blastp";
        this.databaseFolder = this.getBlastDatabaseFolder(properties, storeRoot);
        this.available = this.process(this.blastn, "-version");
        if (!this.available) {
            this.logMissingTools(this.getConfiguredBlastPath(properties));
        }
    }

    public boolean available() {
        return this.available;
    }

    public boolean process(String ... command) {
        ProcessResult processResult = this.run(Arrays.asList(command));
        if (processResult.isOK()) {
            processResult.logAsInfo();
        } else {
            processResult.log();
        }
        return processResult.isOK();
    }

    @Private
    protected ProcessResult run(List<String> command) {
        return ProcessExecutionHelper.run(command, this.operationLog, this.machineLog);
    }

    protected List<String> createCommand(SequenceType sequenceType, File queryFile, String parameterPrefix, Map<String, String> parameters) {
        String[] options;
        String defaultTask;
        ArrayList<String> command = new ArrayList<String>();
        if (sequenceType == SequenceType.NUCL) {
            command.add(this.blastn);
            defaultTask = "blastn";
            options = BLASTN_OPTIONS;
        } else {
            command.add(this.blastp);
            defaultTask = "blastp";
            options = BLASTP_OPTIONS;
        }
        command.add("-db");
        command.add(this.databaseFolder.getAbsolutePath() + "/all-" + sequenceType.toString().toLowerCase());
        command.add("-query");
        command.add(queryFile.getAbsolutePath());
        command.add("-outfmt");
        command.add("6 stitle bitscore score evalue sstart send qstart qend mismatch gaps");
        if (!parameters.containsKey("task")) {
            parameters.put("task", defaultTask);
        }
        for (String option : options) {
            String value = this.tryGetOption(option, sequenceType, parameterPrefix, parameters);
            if (value == null) continue;
            command.add("-" + option);
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            command.add(value);
        }
        return command;
    }

    private String tryGetOption(String option, SequenceType sequenceType, String name, Map<String, String> parameters) {
        String value = parameters.get(option);
        if (value != null) {
            return value;
        }
        String prefixedOption = (sequenceType == SequenceType.NUCL ? "blastn." : "blastp.") + option;
        value = parameters.get(prefixedOption);
        if (value != null) {
            return value;
        }
        value = parameters.get(name + "." + option);
        if (value != null) {
            return value;
        }
        return parameters.get(name + "." + prefixedOption);
    }

    public List<String> processAndDeliverOutput(SequenceType sequenceType, File queryFile, String parameterPrefix, Map<String, String> parameters) {
        List<String> command = this.createCommand(sequenceType, queryFile, parameterPrefix, parameters);
        ProcessResult processResult = this.run(command);
        List<String> output = processResult.getOutput();
        if (processResult.isOK()) {
            return output;
        }
        processResult.log();
        String message = "Couldn't find any results. The reason is most likely that the BLAST database hasn't been populated";
        throw new UserFailureException(message);
    }

    public File getBlastDatabaseFolder(Properties properties, File storeRoot) {
        return this.getFile(properties, BLAST_DATABASES_FOLDER_PROPERTY, DEFAULT_BLAST_DATABASES_FOLDER, storeRoot);
    }

    public String getBLASTToolDirectory(Properties properties) {
        String blastToolsDirectory = this.getConfiguredBlastPath(properties);
        if (!blastToolsDirectory.isEmpty()) {
            if (blastToolsDirectory.endsWith(File.separator)) {
                return blastToolsDirectory;
            }
            return blastToolsDirectory + File.separator;
        }
        return this.getBestGuessBLASTToolDirectory(properties);
    }

    private String getConfiguredBlastPath(Properties properties) {
        String blastToolsDirectory = properties.getProperty(BLAST_TOOLS_DIRECTORY_PROPERTY, "");
        return blastToolsDirectory;
    }

    private String getBestGuessBLASTToolDirectory(Properties properties) {
        String corePluginsFolder = CorePluginsUtils.getCorePluginsFolder(properties, CorePluginScanner.ScannerType.DSS);
        Path path = Paths.get(corePluginsFolder, "eln-lims/bin/blast").toAbsolutePath();
        if (!path.toFile().exists()) {
            return "";
        }
        if (SystemUtils.IS_OS_LINUX) {
            return path.resolve("linux/bin/").toString() + File.separator;
        }
        return path.resolve("mac/bin/").toString() + File.separator;
    }

    public File getFile(Properties properties, String pathProperty, String defaultPath, File storeRoot) {
        String path = properties.getProperty(pathProperty);
        return path == null ? new File(storeRoot, defaultPath) : new File(path);
    }

    public void logMissingTools(String configuredBlastPath) {
        if (StringUtils.isBlank((CharSequence)configuredBlastPath)) {
            this.operationLog.error((Object)"Property 'blast-tools-directory' is not specified and BLAST isn't found in default location.");
        } else {
            this.operationLog.error((Object)("BLAST isn't installed in location '" + configuredBlastPath + "' specified by the property '" + BLAST_TOOLS_DIRECTORY_PROPERTY + "."));
        }
    }

    public static String createDatabaseName(String baseName, SequenceType seqType) {
        return baseName + "-" + seqType.toString().toLowerCase();
    }
}

