/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared.utils;

import ch.ethz.cisd.hotdeploy.PluginContainer;
import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.filesystem.FileOperations;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.filesystem.IFileOperations;
import ch.systemsx.cisd.common.io.PropertyIOUtils;
import ch.systemsx.cisd.common.properties.ExtendedProperties;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.common.string.Template;
import ch.systemsx.cisd.etlserver.ThreadParameters;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.DssPluginType;
import ch.systemsx.cisd.openbis.generic.shared.coreplugin.CorePluginScanner;
import ch.systemsx.cisd.openbis.generic.shared.coreplugin.CorePluginsInjector;
import ch.systemsx.cisd.openbis.generic.shared.coreplugin.CorePluginsUtils;
import java.io.File;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class DssPropertyParametersUtil {
    private static final String LOG_REGISTRATIONS_KEY = "log-registrations";
    private static final String RECOVERY_STATE_KEY = "recovery-state";
    private static final String DSS_TMP_KEY = "dss-tmp";
    public static final String OPENBIS_DSS_SYSTEM_PROPERTIES_PREFIX = "openbis.dss.";
    public static final String DSS_CODE_KEY = "data-store-server-code";
    public static final String STOREROOT_DIR_KEY = "storeroot-dir";
    public static final String DOWNLOAD_URL_KEY = "download-url";
    public static final String SERVER_URL_KEY = "server-url";
    public static final String RSYNC_OPTIONS = "rsync-options";
    public static final String DATA_STREAM_TIMEOUT = "data-stream-timeout";
    public static final String DATA_STREAM_MAX_TIMEOUT = "data-stream-max-timeout";
    public static final int MINIMUM_TIME_TO_KEEP_STREAMS_DEFAULT = 5;
    public static final int MAXIMUM_TIME_TO_KEEP_STREAMS_DEFAULT = 14400;
    static final String DSS_TEMP_DIR_PATH = "dss-temp-dir";
    @Private
    static final String EMPTY_TEST_FILE_NAME = "an-empty-test-file";
    public static final String DSS_REGISTRATION_LOG_DIR_PATH = "dss-registration-log-dir";
    public static final String DSS_RECOVERY_STATE_DIR_PATH = "dss-recovery-state-dir";
    public static final String SERVICE_PROPERTIES_FILE = "etc/service.properties";
    private static final String EXPLANATION = "Please make sure this directory exists on the local file system and is writable by the data store server or provide such a directory by the configuration parameter '${path-key}'.";
    private static final Template NON_EXISTING_DIR_TEMPLATE = new Template("Could not create ${dir-description} at path: ${path}. Please make sure this directory exists on the local file system and is writable by the data store server or provide such a directory by the configuration parameter '${path-key}'.");
    private static final Template NON_SAME_VOLUME_TEMPLATE = new Template("By the configuration parameter '${path-a-key}' directory '${path-a}' and by the configuration parameter'${path-b-key}' directory '${path-b}' are not on the same file system. ");
    private static final Template NON_WRITABLE_TEMPLATE = new Template("By the configuration parameter '${path-a-key}' directory '${path-a}' is not writable. ");
    private static final Template NON_VOLUME_TEMPLATE = new Template("Volume information from the configuration parameter '${path-a-key}' directory '${path-a}' is not retrivable. ");
    private static final Template NON_MOVE_TEMPLATE = new Template("Move operation failed from the configuration parameter '${path-a-key}' directory '${path-a}' to from the configuration parameter '${path-b-key}' directory '${path-b}'. ");
    private static File dssTmp;
    private static File recoveryState;
    private static File logRegistrations;
    private static ExtendedProperties fullServiceProperties;
    private static AtomicInteger atomicEmptyFileIndex;

    public static ExtendedProperties loadServiceProperties() {
        if (fullServiceProperties == null) {
            ExtendedProperties properties = DssPropertyParametersUtil.loadProperties(SERVICE_PROPERTIES_FILE);
            CorePluginsUtils.addCorePluginsProperties(properties, CorePluginScanner.ScannerType.DSS);
            ExtendedProperties serviceProperties = DssPropertyParametersUtil.extendProperties(properties);
            CorePluginsInjector injector = new CorePluginsInjector(CorePluginScanner.ScannerType.DSS, DssPluginType.values());
            Map<String, File> pluginFolders = injector.injectCorePlugins(serviceProperties);
            if (PluginContainer.tryGetInstance() == null) {
                PluginContainer.initHotDeployment();
            }
            for (String name : pluginFolders.keySet()) {
                File mainFolder = pluginFolders.get(name);
                File hotDeployFolder = new File(mainFolder, "plugin");
                if (!hotDeployFolder.exists() || !hotDeployFolder.isDirectory() || PluginContainer.tryGetInstance((String)name) != null) continue;
                PluginContainer pluginContainer = PluginContainer.initHotDeployment((String)name);
                pluginContainer.addPluginDirectory(hotDeployFolder);
                pluginContainer.refresh(true);
            }
            fullServiceProperties = serviceProperties;
        }
        return fullServiceProperties;
    }

    public static ExtendedProperties loadProperties(String filePath) {
        return DssPropertyParametersUtil.extendProperties(PropertyIOUtils.loadProperties(filePath));
    }

    static ExtendedProperties extendProperties(Properties properties) {
        Properties systemProperties = System.getProperties();
        ExtendedProperties dssSystemProperties = ExtendedProperties.getSubset(systemProperties, OPENBIS_DSS_SYSTEM_PROPERTIES_PREFIX, true);
        Set<Map.Entry<Object, Object>> entrySet = dssSystemProperties.entrySet();
        for (Map.Entry<Object, Object> entry : entrySet) {
            properties.put(entry.getKey(), entry.getValue());
        }
        return ExtendedProperties.createWith(properties);
    }

    public static long getHighwaterMark(ThreadParameters threadParameters, Properties properties) {
        Long incomingShareMinimumFreeSpace = threadParameters.getIncomingShareMinimumFreeSpace();
        if (incomingShareMinimumFreeSpace != null) {
            return incomingShareMinimumFreeSpace / 1024L;
        }
        return PropertyUtils.getLong(properties, "highwater-mark", -1L);
    }

    public static String getDataStoreCode(Properties serviceProperties) {
        return PropertyUtils.getMandatoryProperty(serviceProperties, DSS_CODE_KEY).toUpperCase();
    }

    public static final File getStoreRootDir(Properties properties) {
        return FileUtilities.normalizeFile(new File(PropertyUtils.getMandatoryProperty(properties, STOREROOT_DIR_KEY)));
    }

    public static List<String> getRsyncOptions(Properties serviceProperties) {
        String rsyncOptions = serviceProperties.getProperty(RSYNC_OPTIONS, null);
        if (rsyncOptions == null) {
            return null;
        }
        return Arrays.asList(rsyncOptions.split(" "));
    }

    public static String getOpenBisServerUrl(Properties serviceProperties) {
        return PropertyUtils.getMandatoryProperty(serviceProperties, SERVER_URL_KEY);
    }

    public static String getDownloadUrl(Properties serviceProperties) {
        return PropertyUtils.getProperty(serviceProperties, DOWNLOAD_URL_KEY, "");
    }

    public static int getDataStreamTimeout(Properties serviceProperties) {
        return PropertyUtils.getPosInt(serviceProperties, DATA_STREAM_TIMEOUT, 5);
    }

    public static int getDataStreamMaxTimeout(Properties serviceProperties) {
        return PropertyUtils.getPosInt(serviceProperties, DATA_STREAM_MAX_TIMEOUT, 14400);
    }

    public static File getDssInternalTempDir(Properties properties) {
        return DssPropertyParametersUtil.getDssInternalTempDir(FileOperations.getInstance(), properties);
    }

    @Private
    static File getDssInternalTempDir(IFileOperations fileOperations, Properties properties) {
        if (dssTmp == null) {
            DssPropertyParametersUtil.createAndTestSpecialDirectories(fileOperations, properties);
        }
        return dssTmp;
    }

    public static File getDssRegistrationLogDir(Properties properties) {
        return DssPropertyParametersUtil.getDssRegistrationLogDir(FileOperations.getInstance(), properties);
    }

    @Private
    static File getDssRegistrationLogDir(IFileOperations fileOperations, Properties properties) {
        if (logRegistrations == null) {
            DssPropertyParametersUtil.createAndTestSpecialDirectories(fileOperations, properties);
        }
        return logRegistrations;
    }

    public static File getDssRecoveryStateDir(Properties properties) {
        return DssPropertyParametersUtil.getDssRecoveryStateDir(FileOperations.getInstance(), properties);
    }

    @Private
    static File getDssRecoveryStateDir(IFileOperations fileOperations, Properties properties) {
        if (recoveryState == null) {
            DssPropertyParametersUtil.createAndTestSpecialDirectories(fileOperations, properties);
        }
        return recoveryState;
    }

    private static File getDir(IFileOperations fileOperations, Properties properties, String defaultDirName, String dirDescription, String pathKey) {
        String defaultRegistrationLogDirPath = new File(System.getProperty("user.dir"), defaultDirName).getAbsolutePath();
        String registrationLogDirPath = PropertyUtils.getProperty(properties, pathKey, defaultRegistrationLogDirPath);
        File registrationLogDir = new File(registrationLogDirPath);
        fileOperations.mkdirs(registrationLogDir);
        DssPropertyParametersUtil.assertDirExists(fileOperations, registrationLogDir, dirDescription, pathKey);
        return registrationLogDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isWritable(IFileOperations fileOperations, Path path) {
        boolean created;
        block6: {
            created = false;
            File file = null;
            try {
                String threadSafeEmptyTestFileName = EMPTY_TEST_FILE_NAME + atomicEmptyFileIndex.incrementAndGet();
                file = Paths.get(path.toString(), threadSafeEmptyTestFileName).toFile();
                created = fileOperations.createNewFile(file);
                if (!created || file == null) break block6;
                fileOperations.delete(file);
            }
            catch (Exception ex) {
                created = false;
            }
            finally {
                if (created && file != null) {
                    fileOperations.delete(file);
                }
            }
        }
        return created;
    }

    private static FileStore getVolumeInfo(Path path, String key) {
        FileStore info = null;
        try {
            info = Files.getFileStore(path);
        }
        catch (Exception ex) {
            DssPropertyParametersUtil.createException(NON_VOLUME_TEMPLATE, key, path, null, null);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isMoveFromTo(IFileOperations fileOperations, Path pathA, Path pathB) {
        boolean moved;
        block11: {
            File originalfile;
            boolean created;
            block10: {
                created = false;
                moved = false;
                originalfile = null;
                File toMove = null;
                try {
                    String threadSafeEmptyTestFileName = EMPTY_TEST_FILE_NAME + atomicEmptyFileIndex.incrementAndGet();
                    originalfile = Paths.get(pathA.toString(), threadSafeEmptyTestFileName).toFile();
                    created = fileOperations.createNewFile(originalfile);
                    if (created) {
                        toMove = Paths.get(pathB.toString(), threadSafeEmptyTestFileName).toFile();
                        fileOperations.move(originalfile, toMove);
                        moved = true;
                    }
                    if (!moved || toMove == null) break block10;
                    fileOperations.delete(toMove);
                }
                catch (Exception ex) {
                    moved = false;
                    break block11;
                }
                finally {
                    if (moved && toMove != null) {
                        fileOperations.delete(toMove);
                    } else if (created && originalfile != null) {
                        fileOperations.delete(originalfile);
                    }
                }
                break block11;
            }
            if (created && originalfile != null) {
                fileOperations.delete(originalfile);
            }
        }
        return moved;
    }

    private static void createAndTestSpecialDirectories(IFileOperations fileOperations, Properties properties) {
        dssTmp = DssPropertyParametersUtil.getDir(fileOperations, properties, DSS_TMP_KEY, "an internal temp directory for the data store server", DSS_TEMP_DIR_PATH);
        Path dssTmpPath = dssTmp.toPath();
        recoveryState = DssPropertyParametersUtil.getDir(fileOperations, properties, RECOVERY_STATE_KEY, "a directory for storing recovery state for the dss", DSS_RECOVERY_STATE_DIR_PATH);
        Path recoveryStatePath = recoveryState.toPath();
        logRegistrations = DssPropertyParametersUtil.getDir(fileOperations, properties, LOG_REGISTRATIONS_KEY, "a directory for storing registration logs", DSS_REGISTRATION_LOG_DIR_PATH);
        Path logRegistrationsPath = logRegistrations.toPath();
        FileStore dssTmpStore = DssPropertyParametersUtil.getVolumeInfo(dssTmpPath, DSS_TMP_KEY);
        FileStore recoveryStateStore = DssPropertyParametersUtil.getVolumeInfo(recoveryStatePath, RECOVERY_STATE_KEY);
        FileStore logRegistrationsState = DssPropertyParametersUtil.getVolumeInfo(logRegistrationsPath, LOG_REGISTRATIONS_KEY);
        if (dssTmpStore == null) {
            throw DssPropertyParametersUtil.createException(NON_VOLUME_TEMPLATE, DSS_TMP_KEY, dssTmpPath, null, null);
        }
        if (recoveryStateStore == null) {
            throw DssPropertyParametersUtil.createException(NON_VOLUME_TEMPLATE, RECOVERY_STATE_KEY, recoveryStatePath, null, null);
        }
        if (logRegistrationsState == null) {
            throw DssPropertyParametersUtil.createException(NON_VOLUME_TEMPLATE, LOG_REGISTRATIONS_KEY, logRegistrationsPath, null, null);
        }
        if (!dssTmpStore.equals(recoveryStateStore)) {
            throw DssPropertyParametersUtil.createException(NON_SAME_VOLUME_TEMPLATE, DSS_TMP_KEY, dssTmpPath, RECOVERY_STATE_KEY, recoveryStatePath);
        }
        if (!dssTmpStore.equals(logRegistrationsState)) {
            throw DssPropertyParametersUtil.createException(NON_SAME_VOLUME_TEMPLATE, DSS_TMP_KEY, dssTmpPath, LOG_REGISTRATIONS_KEY, logRegistrationsPath);
        }
        if (!DssPropertyParametersUtil.isWritable(fileOperations, dssTmpPath)) {
            throw DssPropertyParametersUtil.createException(NON_WRITABLE_TEMPLATE, DSS_TMP_KEY, dssTmpPath, null, null);
        }
        if (!DssPropertyParametersUtil.isWritable(fileOperations, recoveryStatePath)) {
            throw DssPropertyParametersUtil.createException(NON_WRITABLE_TEMPLATE, RECOVERY_STATE_KEY, recoveryStatePath, null, null);
        }
        if (!DssPropertyParametersUtil.isWritable(fileOperations, logRegistrationsPath)) {
            throw DssPropertyParametersUtil.createException(NON_WRITABLE_TEMPLATE, LOG_REGISTRATIONS_KEY, logRegistrationsPath, null, null);
        }
        if (!DssPropertyParametersUtil.isMoveFromTo(fileOperations, dssTmpPath, recoveryStatePath)) {
            throw DssPropertyParametersUtil.createException(NON_MOVE_TEMPLATE, DSS_TMP_KEY, dssTmpPath, RECOVERY_STATE_KEY, recoveryStatePath);
        }
        if (!DssPropertyParametersUtil.isMoveFromTo(fileOperations, dssTmpPath, logRegistrationsPath)) {
            throw DssPropertyParametersUtil.createException(NON_MOVE_TEMPLATE, DSS_TMP_KEY, dssTmpPath, LOG_REGISTRATIONS_KEY, logRegistrationsPath);
        }
    }

    private static void assertDirExists(IFileOperations fileOperations, File dir, String dirDescription, String pathKey) {
        if (!fileOperations.exists(dir)) {
            throw DssPropertyParametersUtil.createException(NON_EXISTING_DIR_TEMPLATE.createFreshCopy(), dir, dirDescription, pathKey);
        }
    }

    private static ConfigurationFailureException createException(Template template, String pathAKey, Path pathA, String pathBKey, Path pathB) {
        template.bind("path-a-key", pathAKey);
        template.bind("path-a", pathA.toString());
        if (pathBKey != null && pathB != null) {
            template.bind("path-b-key", pathBKey);
            template.bind("path-b", pathB.toString());
        }
        ConfigurationFailureException e = new ConfigurationFailureException(template.createText());
        return e;
    }

    private static ConfigurationFailureException createException(Template template, File dir, String dirName, String pathKey) {
        template.attemptToBind("dir-description", dirName);
        template.bind("path", dir.getPath());
        template.bind("path-key", pathKey);
        ConfigurationFailureException e = new ConfigurationFailureException(template.createText());
        return e;
    }

    static {
        atomicEmptyFileIndex = new AtomicInteger();
    }
}

