/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ImageUtilReaderPool<T> {
    private ReaderUtil<T> util;
    HashMap<String, List<T>> poolMap = new HashMap();

    public ImageUtilReaderPool(ReaderUtil<T> util) {
        this.util = util;
    }

    private List<T> getReadersList(String sessionId) {
        if (!this.poolMap.containsKey(sessionId)) {
            this.poolMap.put(sessionId, new ArrayList());
        }
        return this.poolMap.get(sessionId);
    }

    private T findMatchingReader(List<T> readersList, String imageLibraryNameOrNull, String imageLibraryReaderNameOrNull) {
        for (T reader : readersList) {
            if (!this.util.isSameLibraryAndReader(reader, imageLibraryNameOrNull, imageLibraryReaderNameOrNull)) continue;
            return reader;
        }
        return null;
    }

    public synchronized void put(String sessionId, T reader) {
        List<T> readersList = this.getReadersList(sessionId);
        readersList.add(reader);
    }

    public synchronized T get(String sessionId, String imageLibraryNameOrNull, String imageLibraryReaderNameOrNull) {
        List<T> readersList = this.getReadersList(sessionId);
        T selectedReader = this.findMatchingReader(readersList, imageLibraryNameOrNull, imageLibraryReaderNameOrNull);
        if (selectedReader != null) {
            readersList.remove(selectedReader);
            return selectedReader;
        }
        return this.util.create(imageLibraryNameOrNull, imageLibraryReaderNameOrNull);
    }

    public synchronized void releaseSession(String sessionId) {
        if (this.poolMap.containsKey(sessionId)) {
            List<T> list = this.poolMap.get(sessionId);
            for (T reader : list) {
                this.util.close(reader);
            }
            this.poolMap.remove(sessionId);
        }
    }

    public static interface ReaderUtil<T> {
        public T create(String var1, String var2);

        public boolean isSameLibraryAndReader(T var1, String var2, String var3);

        public void close(T var1);
    }
}

