/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared.utils;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class Jython27ClassLoader
extends ClassLoader {
    private static final Logger machineLog = LogFactory.getLogger(LogCategory.MACHINE, Jython27ClassLoader.class);
    private static final List<String> EXCLUDED_PACKAGES_STARTS = Arrays.asList("java", "jdk.", "sun.", "com.sun.");
    private final URLClassLoader jythonJarClassLoader;
    private final Map<String, Class<?>> cachedClasses = new HashMap();

    public Jython27ClassLoader(File jythonJar) {
        if (!jythonJar.exists()) {
            throw new EnvironmentFailureException("JAR file does not exist: " + jythonJar.getAbsolutePath());
        }
        if (jythonJar.isDirectory()) {
            throw new EnvironmentFailureException("JAR file is a directory: " + jythonJar.getAbsolutePath());
        }
        try {
            this.jythonJarClassLoader = new URLClassLoader(new URL[]{jythonJar.toURI().toURL()}, null);
        }
        catch (MalformedURLException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = this.cachedClasses.get(name);
        if (clazz == null) {
            if (!this.excludedPackageStart(name)) {
                clazz = this.tryLoadClass(this.jythonJarClassLoader, name);
            }
            if (clazz == null) {
                if (name.contains(".v27.")) {
                    clazz = this.tryLoadClass(this, name);
                    if (clazz == null) {
                        return super.loadClass(name, resolve);
                    }
                } else {
                    return super.loadClass(name, resolve);
                }
            }
        }
        if (resolve) {
            this.resolveClass(clazz);
        }
        this.cachedClasses.put(name, clazz);
        this.definePackage(name);
        return clazz;
    }

    private boolean excludedPackageStart(String className) {
        for (String packageStart : EXCLUDED_PACKAGES_STARTS) {
            if (!className.startsWith(packageStart)) continue;
            return true;
        }
        return false;
    }

    private void definePackage(String className) {
        String packageName = this.getPackageName(className);
        if (this.getPackage(packageName) == null) {
            this.definePackage(packageName, null, null, null, null, null, null, null);
        }
    }

    private String getPackageName(String className) {
        int offset = className.lastIndexOf(46);
        return offset == -1 ? null : className.substring(0, offset);
    }

    @Override
    public URL getResource(String name) {
        URL resource = this.jythonJarClassLoader.getResource(name);
        if (resource != null) {
            return resource;
        }
        return super.getResource(name);
    }

    @Override
    protected URL findResource(String name) {
        URL resource = this.jythonJarClassLoader.findResource(name);
        if (resource != null) {
            return resource;
        }
        return super.findResource(name);
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        Enumeration<URL> resources = this.jythonJarClassLoader.findResources(name);
        if (resources != null) {
            return resources;
        }
        return super.findResources(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Class<?> tryLoadClass(ClassLoader classLoader, String name) {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            InputStream stream = classLoader.getResourceAsStream(name.replace('.', '/') + ".class");
            if (stream == null) return null;
            try {
                byte[] bytes = IOUtils.toByteArray((InputStream)stream);
                Class<?> clazz = this.defineClass(name, bytes, 0, bytes.length);
                return clazz;
            }
            catch (SecurityException ex) {
                Class<?> clazz = null;
                return clazz;
            }
            catch (IOException ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary(ex);
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
        }
    }
}

