/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared.utils;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.jython.IJythonInterpreterFactory;
import ch.systemsx.cisd.common.jython.evaluator.IJythonEvaluatorFactory;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.Jython27ClassLoader;
import java.io.File;

public class Jython27FactoriesProvider {
    private static final ClassLoader JYTHON_CLASS_LOADER = Jython27FactoriesProvider.createJythonClassLoader();
    private static IJythonEvaluatorFactory jythonEvaluatorFactory;
    private static IJythonInterpreterFactory jythonInterpreterFactory;

    private static ClassLoader createJythonClassLoader() {
        File[] files = new File("lib").listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.getName().startsWith("jython27")) continue;
                return new Jython27ClassLoader(file);
            }
        }
        return Jython27ClassLoader.class.getClassLoader();
    }

    public static synchronized IJythonEvaluatorFactory getEvaluatorFactory() {
        if (jythonEvaluatorFactory == null) {
            try {
                jythonEvaluatorFactory = (IJythonEvaluatorFactory)JYTHON_CLASS_LOADER.loadClass("ch.systemsx.cisd.common.jython.v27.Jython27EvaluatorFactory").newInstance();
            }
            catch (Exception ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary(ex);
            }
        }
        return jythonEvaluatorFactory;
    }

    public static synchronized IJythonInterpreterFactory getInterpreterFactory() {
        if (jythonInterpreterFactory == null) {
            try {
                jythonInterpreterFactory = (IJythonInterpreterFactory)JYTHON_CLASS_LOADER.loadClass("ch.systemsx.cisd.common.jython.v27.Jython27InterpreterFactory").newInstance();
            }
            catch (Exception ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary(ex);
            }
        }
        return jythonInterpreterFactory;
    }
}

