/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared;

import ch.systemsx.cisd.common.filesystem.QueueingPathRemoverService;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.common.spring.ExposablePropertyPlaceholderConfigurer;
import ch.systemsx.cisd.openbis.generic.shared.ISessionWorkspaceProvider;
import java.io.File;
import java.io.FileFilter;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Component;

@Component(value="session-workspace-provider")
public class SessionWorkspaceProvider
implements ISessionWorkspaceProvider {
    public static final String INTERNAL_SERVICE_NAME = "session-workspace-provider";
    public static final String SESSION_WORKSPACE_ROOT_DIR_KEY = "session-workspace-root-dir";
    public static final String SESSION_WORKSPACE_ROOT_DIR_DEFAULT = "sessionWorkspace";
    public static final String SESSION_WORKSPACE_SHREDDER_QUEUE_FILE = ".shredder";
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, SessionWorkspaceProvider.class);
    private Properties serviceProperties;
    private File sessionWorkspaceRootDir;

    public SessionWorkspaceProvider() {
    }

    SessionWorkspaceProvider(Properties serviceProperties) {
        this.serviceProperties = serviceProperties;
    }

    @PostConstruct
    void init() throws Exception {
        String sessionWorkspaceRootDirString = PropertyUtils.getProperty(this.serviceProperties, SESSION_WORKSPACE_ROOT_DIR_KEY, SESSION_WORKSPACE_ROOT_DIR_DEFAULT);
        this.sessionWorkspaceRootDir = new File(sessionWorkspaceRootDirString);
        operationLog.info((Object)("Session workspace root dir '" + this.sessionWorkspaceRootDir.getCanonicalPath() + "'"));
        if (!this.sessionWorkspaceRootDir.exists()) {
            this.sessionWorkspaceRootDir.mkdirs();
        }
        QueueingPathRemoverService.start(this.sessionWorkspaceRootDir, new File(SESSION_WORKSPACE_SHREDDER_QUEUE_FILE));
        operationLog.info((Object)"Session workspace shredder service started");
    }

    @Override
    public Map<String, File> getSessionWorkspaces() {
        File[] sessionWorkspaces = this.sessionWorkspaceRootDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return false == file.isHidden();
            }
        });
        TreeMap<String, File> map = new TreeMap<String, File>();
        if (sessionWorkspaces != null) {
            for (File sessionWorkspace : sessionWorkspaces) {
                map.put(sessionWorkspace.getName(), sessionWorkspace);
            }
        }
        return map;
    }

    @Override
    public File getSessionWorkspace(String sessionToken) {
        File sessionWorkspace = new File(this.sessionWorkspaceRootDir, sessionToken);
        if (!sessionWorkspace.exists()) {
            sessionWorkspace.mkdirs();
            operationLog.info((Object)"Session workspace created");
        }
        return sessionWorkspace;
    }

    @Override
    public void deleteSessionWorkspace(String sessionToken) {
        try {
            File sessionWorkspace = new File(this.sessionWorkspaceRootDir, sessionToken);
            if (sessionWorkspace.exists()) {
                QueueingPathRemoverService.removeRecursively(sessionWorkspace);
                operationLog.info((Object)"Session workspace added to shredder queue");
            }
        }
        catch (Exception e) {
            operationLog.warn((Object)"Session workspace could not be shredded", (Throwable)e);
        }
    }

    @Resource(name="propertyConfigurer")
    private void setServicePropertiesPlaceholder(ExposablePropertyPlaceholderConfigurer servicePropertiesPlaceholder) {
        this.serviceProperties = servicePropertiesPlaceholder.getResolvedProps();
    }
}

