/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.authorization;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.generic.shared.authorization.IAuthorizationConfig;
import ch.systemsx.cisd.openbis.generic.shared.authorization.IAuthorizationConfigProperties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="authorization-config")
public class AuthorizationConfig
implements IAuthorizationConfig {
    static final String PROJECT_LEVEL_AUTHORIZATION_ENABLED_PROPERTY_NAME = "authorization.project-level.enabled";
    static final boolean PROJECT_LEVEL_AUTHORIZATION_ENABLED_DEFAULT = false;
    static final String PROJECT_LEVEL_AUTHORIZATION_USERS_PROPERTY_NAME = "authorization.project-level.users";
    static final String PROJECT_LEVEL_AUTHORIZATION_USERS_DEFAULT = ".*";
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, AuthorizationConfig.class);
    private boolean projectLevelEnabled;
    private Pattern projectLevelUsers;
    @Autowired
    private IAuthorizationConfigProperties properties;

    AuthorizationConfig() {
    }

    @PostConstruct
    void init() {
        String projectLevelEnabledString = this.properties.getProperty(PROJECT_LEVEL_AUTHORIZATION_ENABLED_PROPERTY_NAME);
        this.projectLevelEnabled = projectLevelEnabledString == null || projectLevelEnabledString.trim().isEmpty() ? false : Boolean.parseBoolean(projectLevelEnabledString);
        String projectLevelUsersString = this.properties.getProperty(PROJECT_LEVEL_AUTHORIZATION_USERS_PROPERTY_NAME);
        this.projectLevelUsers = projectLevelUsersString == null || projectLevelUsersString.trim().isEmpty() ? Pattern.compile(PROJECT_LEVEL_AUTHORIZATION_USERS_DEFAULT) : Pattern.compile(projectLevelUsersString);
        if (this.projectLevelEnabled) {
            operationLog.info((Object)("Project level authorization is enabled for users '" + this.projectLevelUsers + "'"));
        }
    }

    @Override
    public boolean isProjectLevelEnabled() {
        return this.projectLevelEnabled;
    }

    @Override
    public boolean isProjectLevelUser(String userId) {
        if (userId == null || userId.isEmpty()) {
            return false;
        }
        Matcher matcher = this.projectLevelUsers.matcher(userId);
        return matcher.matches();
    }

    void setProperties(IAuthorizationConfigProperties properties) {
        this.properties = properties;
    }
}

