/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic;

import ch.systemsx.cisd.openbis.generic.shared.basic.IDeletionProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Deletion;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;

public class DeletionUtils {
    private static final int MAX_NUMBER = 5;

    public static String createDescriptionOfDeletedEntities(Deletion deletion) {
        String dataSets;
        String samples;
        StringBuilder builder = new StringBuilder();
        String experiments = DeletionUtils.createList(deletion, EntityKind.EXPERIMENT, "Experiment");
        if (experiments.length() > 0) {
            builder.append(experiments);
        }
        if ((samples = DeletionUtils.createList(deletion, EntityKind.SAMPLE, "Sample")).length() > 0) {
            builder.append(samples);
        }
        if ((dataSets = DeletionUtils.createList(deletion, EntityKind.DATA_SET, "Data Set")).length() > 0) {
            builder.append(dataSets);
        }
        return builder.toString();
    }

    private static String createList(Deletion deletion, EntityKind entityKind, String name) {
        StringBuilder builder = new StringBuilder();
        int count = 0;
        for (IEntityInformationHolderWithIdentifier entity : deletion.getDeletedEntities()) {
            if (entity.getEntityKind() != entityKind || count >= 5) continue;
            builder.append("  ").append(entity.getIdentifier()).append(" (");
            builder.append(entity.getEntityType().getCode()).append(")\n");
            ++count;
        }
        int numberOfAdditionalEntities = 0;
        switch (entityKind) {
            case DATA_SET: {
                numberOfAdditionalEntities = deletion.getTotalDatasetsCount();
                break;
            }
            case SAMPLE: {
                numberOfAdditionalEntities = deletion.getTotalSamplesCount();
                break;
            }
            case EXPERIMENT: {
                numberOfAdditionalEntities = deletion.getTotalExperimentsCount();
                break;
            }
        }
        numberOfAdditionalEntities -= count;
        if (count == 0) {
            if (numberOfAdditionalEntities == 0) {
                return "";
            }
            if (numberOfAdditionalEntities == 1) {
                return "1 " + name + "\n";
            }
            if (numberOfAdditionalEntities > 1) {
                return numberOfAdditionalEntities + " " + name + "s\n";
            }
        }
        if (numberOfAdditionalEntities > 0) {
            builder.append("  and ").append(numberOfAdditionalEntities).append(" more\n");
        }
        if (count == 1) {
            return name + " " + builder.toString();
        }
        return name + "s:\n" + builder.toString();
    }

    public static boolean isDeleted(IDeletionProvider deletableOrNull) {
        return deletableOrNull != null && deletableOrNull.getDeletion() != null;
    }

    public static boolean isDeleted(Object objectOrNull) {
        if (objectOrNull != null && objectOrNull instanceof IDeletionProvider) {
            return DeletionUtils.isDeleted((IDeletionProvider)objectOrNull);
        }
        return false;
    }
}

