/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic;

import java.util.Arrays;

public class ValidationUtilities {

    public static class HyperlinkValidationHelper {
        private static final String HYPERLINK_REGEXP = "[^<>()\\[\\]]*";
        private static final String[] HYPERLINK_VALID_PROTOCOLS = new String[]{"http://", "https://", "ftp://"};

        public static final boolean isProtocolValid(String string) {
            for (String protocol : HYPERLINK_VALID_PROTOCOLS) {
                if (string.indexOf(protocol) != 0) continue;
                return true;
            }
            return false;
        }

        public static final boolean isFormatValid(String string) {
            return string.matches(HYPERLINK_REGEXP);
        }

        public static final String getValidProtocolsAsString() {
            return Arrays.toString(HYPERLINK_VALID_PROTOCOLS);
        }
    }
}

