/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic.dto;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm;

public abstract class AbstractEntityProperty
implements IEntityProperty {
    private static final long serialVersionUID = 35L;
    private PropertyType propertyType;
    private Long ordinal;
    private boolean scriptable;
    private boolean dynamic;

    @Override
    public PropertyType getPropertyType() {
        return this.propertyType;
    }

    @Override
    public void setPropertyType(PropertyType propertyType) {
        this.propertyType = propertyType;
    }

    @Override
    public String tryGetAsString() {
        if (this.propertyType == null) {
            return null;
        }
        DataType dataType = this.propertyType.getDataType();
        if (dataType == null) {
            return this.getValue();
        }
        switch (dataType.getCode()) {
            case CONTROLLEDVOCABULARY: {
                VocabularyTerm vocabularyTerm = this.getVocabularyTerm();
                return vocabularyTerm != null ? vocabularyTerm.getCode() : this.getValue();
            }
            case MATERIAL: {
                Material material = this.getMaterial();
                return material != null ? MaterialIdentifier.print(material.getCode(), material.getMaterialType().getCode()) : this.getValue();
            }
            case SAMPLE: {
                Sample sample = this.getSample();
                return sample != null ? sample.getPermId() : this.getValue();
            }
            case DATE: {
                String timestamp = this.getValue();
                return timestamp != null ? timestamp.split(" ")[0] : null;
            }
        }
        return this.getValue();
    }

    @Override
    public String tryGetOriginalValue() {
        return this.tryGetAsString();
    }

    @Override
    public String getValue() {
        return null;
    }

    @Override
    public void setValue(String value) {
    }

    @Override
    public Material getMaterial() {
        return null;
    }

    @Override
    public void setMaterial(Material material) {
    }

    @Override
    public Sample getSample() {
        return null;
    }

    @Override
    public void setSample(Sample sample) {
    }

    @Override
    public VocabularyTerm getVocabularyTerm() {
        return null;
    }

    @Override
    public void setVocabularyTerm(VocabularyTerm vocabularyTerm) {
    }

    @Override
    public void setOrdinal(Long ordinal) {
        this.ordinal = ordinal;
    }

    @Override
    public Long getOrdinal() {
        return this.ordinal;
    }

    @Override
    public boolean isManaged() {
        return false;
    }

    public void setScriptable(boolean scriptable) {
        this.scriptable = scriptable;
    }

    @Override
    public boolean isScriptable() {
        return this.scriptable;
    }

    @Override
    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public String toString() {
        return this.propertyType + ": " + this.tryGetAsString();
    }

    @Override
    public int compareTo(IEntityProperty o) {
        Long thisOrdinal = this.getOrdinal();
        Long otherOrdinal = o.getOrdinal();
        if (thisOrdinal != null && otherOrdinal != null) {
            return thisOrdinal.compareTo(otherOrdinal);
        }
        PropertyType thisPropertyType = this.getPropertyType();
        PropertyType otherPropertyType = o.getPropertyType();
        if (thisPropertyType.getLabel().equals(otherPropertyType.getLabel())) {
            return thisPropertyType.getCode().compareTo(otherPropertyType.getCode());
        }
        return thisPropertyType.getLabel().compareTo(otherPropertyType.getLabel());
    }
}

