/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic.dto;

import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithProperties;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityWithDeletionInformation;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIsStub;
import ch.systemsx.cisd.openbis.generic.shared.basic.IPermIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.ITaggable;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Code;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CodeWithRegistrationAndModificationDate;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ContainerDataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataStore;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Deletion;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.LinkDataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Metaproject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PhysicalDataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SourceType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Space;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public abstract class AbstractExternalData
extends CodeWithRegistrationAndModificationDate<AbstractExternalData>
implements IEntityWithDeletionInformation,
IEntityInformationHolderWithProperties,
IIdAndCodeHolder,
IPermIdHolder,
IIsStub,
ITaggable {
    private static final long serialVersionUID = 35L;
    private Map<String, ContainerAndOrder> containersAndOrderByContainerId = new TreeMap<String, ContainerAndOrder>();
    private Map<Long, ContainerAndOrder> containersAndOrderByContainerTechId = new TreeMap<Long, ContainerAndOrder>();
    private boolean derived;
    private Long id;
    private Deletion deletion;
    private Experiment experiment;
    private DataSetType dataSetType;
    private Date productionDate;
    private String producerCode;
    private Collection<AbstractExternalData> parents;
    private Long size;
    private Sample sample;
    private String sampleIdentifier;
    private String sampleCode;
    private SampleType sampleType;
    private Collection<AbstractExternalData> children;
    private List<IEntityProperty> dataSetProperties;
    private DataStore dataStore;
    private String permlink;
    private boolean storageConfirmation;
    private boolean isStub;
    private boolean isPostRegistered;
    private Collection<Metaproject> metaprojects;
    private Date accessTimestamp;

    public AbstractExternalData(boolean isStub) {
        this.isStub = isStub;
    }

    public boolean isAvailable() {
        return true;
    }

    public boolean isContainer() {
        return false;
    }

    public boolean isLinkData() {
        return false;
    }

    public boolean isPlaceHolderDataSet() {
        return false;
    }

    public PhysicalDataSet tryGetAsDataSet() {
        return null;
    }

    public ContainerDataSet tryGetAsContainerDataSet() {
        return null;
    }

    public LinkDataSet tryGetAsLinkDataSet() {
        return null;
    }

    public String getPermlink() {
        return this.permlink;
    }

    public void setPermlink(String permlink) {
        this.permlink = permlink;
    }

    public Sample getSample() {
        return this.sample;
    }

    public void setSample(Sample sample) {
        this.sample = sample;
        if (sample != null) {
            this.setSampleIdentifier(sample.getIdentifier());
            this.setSampleType(sample.getSampleType());
            this.setSampleCode(sample.getCode());
        }
    }

    public final String getSampleIdentifier() {
        return this.sampleIdentifier;
    }

    private final void setSampleIdentifier(String sampleIdentifier) {
        this.sampleIdentifier = sampleIdentifier;
    }

    public final String getSampleCode() {
        return this.sampleCode;
    }

    private void setSampleCode(String sampleCode) {
        this.sampleCode = sampleCode;
    }

    public final SampleType getSampleType() {
        return this.sampleType;
    }

    private final void setSampleType(SampleType sampleType) {
        this.sampleType = sampleType;
    }

    public Collection<AbstractExternalData> getChildren() {
        return this.children;
    }

    public void setChildren(Collection<AbstractExternalData> children) {
        this.children = children;
    }

    public final boolean isDerived() {
        return this.derived;
    }

    public final void setDerived(boolean derived) {
        this.derived = derived;
    }

    public final DataSetType getDataSetType() {
        return this.dataSetType;
    }

    public final void setDataSetType(DataSetType dataSetType) {
        this.dataSetType = dataSetType;
    }

    public final Date getProductionDate() {
        return this.productionDate;
    }

    public final void setProductionDate(Date productionDate) {
        this.productionDate = productionDate;
    }

    public final String getDataProducerCode() {
        return this.producerCode;
    }

    public final void setDataProducerCode(String producerCode) {
        this.producerCode = producerCode;
    }

    public Collection<AbstractExternalData> getParents() {
        return this.parents;
    }

    public void setParents(Collection<AbstractExternalData> parents) {
        this.parents = parents;
    }

    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    @Override
    public final Deletion getDeletion() {
        return this.deletion;
    }

    public final void setDeletion(Deletion deletion) {
        this.deletion = deletion;
    }

    public final Experiment getExperiment() {
        return this.experiment;
    }

    public final void setExperiment(Experiment experiment) {
        this.experiment = experiment;
    }

    public void setDataSetProperties(List<IEntityProperty> dataSetProperties) {
        this.dataSetProperties = dataSetProperties;
    }

    @Override
    public List<IEntityProperty> getProperties() {
        return this.dataSetProperties;
    }

    public final DataStore getDataStore() {
        return this.dataStore;
    }

    public final void setDataStore(DataStore dataStore) {
        this.dataStore = dataStore;
    }

    @Override
    public EntityKind getEntityKind() {
        return EntityKind.DATA_SET;
    }

    @Override
    public EntityType getEntityType() {
        return this.dataSetType;
    }

    @Override
    public String getIdentifier() {
        return this.getCode();
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getPermId() {
        return this.getCode();
    }

    @Deprecated
    public ContainerDataSet tryGetContainer() {
        if (this.containersAndOrderByContainerId.isEmpty()) {
            return null;
        }
        return this.containersAndOrderByContainerId.values().iterator().next().getContainerDataSet();
    }

    public void addContainer(ContainerDataSet containerDataSet, Integer orderInContainer) {
        List<AbstractExternalData> components = containerDataSet.getContainedDataSets();
        if (!components.contains(this)) {
            components.add(this);
        }
        ContainerAndOrder containerAndOrder = new ContainerAndOrder(containerDataSet, orderInContainer);
        this.containersAndOrderByContainerId.put(containerDataSet.getCode(), containerAndOrder);
        this.containersAndOrderByContainerTechId.put(containerDataSet.getId(), containerAndOrder);
    }

    public List<ContainerDataSet> getContainerDataSets() {
        ArrayList<ContainerDataSet> containers = new ArrayList<ContainerDataSet>();
        Collection<ContainerAndOrder> values = this.containersAndOrderByContainerId.values();
        for (ContainerAndOrder containerAndOrder : values) {
            containers.add(containerAndOrder.getContainerDataSet());
        }
        return containers;
    }

    public Integer getOrderInContainer(Long containerDataSetTechId) {
        ContainerAndOrder containerAndOrder = this.containersAndOrderByContainerTechId.get(containerDataSetTechId);
        return containerAndOrder == null ? null : containerAndOrder.getOrderInContainer();
    }

    public Integer getOrderInContainer(String containerDataSetCode) {
        ContainerAndOrder containerAndOrder = this.containersAndOrderByContainerId.get(containerDataSetCode);
        return containerAndOrder == null ? null : containerAndOrder.getOrderInContainer();
    }

    public boolean isStorageConfirmation() {
        return this.storageConfirmation || this.isContainer();
    }

    public void setStorageConfirmation(boolean storageConfirmation) {
        this.storageConfirmation = storageConfirmation;
    }

    public void setMetaprojects(Collection<Metaproject> metaprojects) {
        this.metaprojects = metaprojects;
    }

    @Override
    public Collection<Metaproject> getMetaprojects() {
        return this.metaprojects;
    }

    public DataSetKind getDataSetKind() {
        return DataSetKind.PHYSICAL;
    }

    public String getSourceType() {
        return SourceType.create(this.isDerived()).name();
    }

    @Override
    public boolean isStub() {
        return this.isStub;
    }

    public boolean isPostRegistered() {
        return this.isPostRegistered;
    }

    public void setPostRegistered(boolean isPostRegistered) {
        this.isPostRegistered = isPostRegistered;
    }

    public Date getAccessTimestamp() {
        return this.accessTimestamp;
    }

    public void setAccessTimestamp(Date accessTimestamp) {
        this.accessTimestamp = accessTimestamp;
    }

    public Space getSpace() {
        if (this.experiment != null) {
            return this.experiment.getProject().getSpace();
        }
        return this.sample == null ? null : this.sample.getSpace();
    }

    public Project getProject() {
        if (this.experiment != null) {
            return this.experiment.getProject();
        }
        if (this.sample != null) {
            return this.sample.getExperiment() != null ? this.sample.getExperiment().getProject() : this.sample.getProject();
        }
        return null;
    }

    public static final class DataSetComponentsComparator
    implements Comparator<AbstractExternalData> {
        private Long id;

        public DataSetComponentsComparator(TechId techId) {
            this.id = techId.getId();
        }

        @Override
        public int compare(AbstractExternalData o1, AbstractExternalData o2) {
            if (o1 == o2) {
                return 0;
            }
            Integer order1 = o1.getOrderInContainer(this.id);
            Integer order2 = o2.getOrderInContainer(this.id);
            if (order1 == null || order2 == null) {
                return Code.CODE_PROVIDER_COMPARATOR.compare(o1, o2);
            }
            return order1.compareTo(order2);
        }
    }

    static final class ContainerAndOrder
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private ContainerDataSet containerDataSet;
        private Integer orderInContainer;

        public ContainerAndOrder() {
        }

        public ContainerAndOrder(ContainerDataSet containerDataSet, Integer orderInContainer) {
            this.containerDataSet = containerDataSet;
            this.orderInContainer = orderInContainer;
        }

        public ContainerDataSet getContainerDataSet() {
            return this.containerDataSet;
        }

        public Integer getOrderInContainer() {
            return this.orderInContainer;
        }
    }
}

