/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic.dto;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public enum AssociatedEntityKind implements Serializable
{
    SAMPLE("Sample", EntityKind.SAMPLE, EnumSet.of(EntityKind.DATA_SET)),
    EXPERIMENT("Experiment", EntityKind.EXPERIMENT, EnumSet.of(EntityKind.SAMPLE, EntityKind.DATA_SET)),
    DATA_SET("Data Set", EntityKind.DATA_SET, EnumSet.noneOf(EntityKind.class)),
    DATA_SET_PARENT("Parent", EntityKind.DATA_SET, EnumSet.of(EntityKind.DATA_SET)),
    DATA_SET_CHILD("Child", EntityKind.DATA_SET, EnumSet.of(EntityKind.DATA_SET)),
    DATA_SET_CONTAINER("Container", EntityKind.DATA_SET, EnumSet.of(EntityKind.DATA_SET)),
    SAMPLE_CONTAINER("Container", EntityKind.SAMPLE, EnumSet.of(EntityKind.SAMPLE)),
    SAMPLE_CHILD("Child", EntityKind.SAMPLE, EnumSet.of(EntityKind.SAMPLE)),
    SAMPLE_PARENT("Parent", EntityKind.SAMPLE, EnumSet.of(EntityKind.SAMPLE)),
    MATERIAL("Material", EntityKind.MATERIAL, EnumSet.noneOf(EntityKind.class));

    private final String description;
    private final EntityKind entityKind;
    private final Set<EntityKind> sourceEntityKinds;

    private AssociatedEntityKind(String description, EntityKind entityKind, Set<EntityKind> sourceEntityKinds) {
        this.description = description;
        this.entityKind = entityKind;
        this.sourceEntityKinds = sourceEntityKinds;
    }

    public final String getDescription() {
        return this.description;
    }

    public final EntityKind getEntityKind() {
        return this.entityKind;
    }

    public static List<AssociatedEntityKind> getAssociatedEntityKinds(EntityKind sourceEntity) {
        ArrayList<AssociatedEntityKind> result = new ArrayList<AssociatedEntityKind>();
        for (AssociatedEntityKind associatedEntityKind : AssociatedEntityKind.values()) {
            if (!associatedEntityKind.sourceEntityKinds.contains(sourceEntity)) continue;
            result.add(associatedEntityKind);
        }
        return result;
    }
}

