/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic.dto;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.id.IObjectId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.id.dataset.IDataSetId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.id.experiment.IExperimentId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.id.material.IMaterialId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.id.sample.ISampleId;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class BasicMetaprojectUpdates
implements Serializable {
    private static final long serialVersionUID = 35L;
    private String description;
    private List<ISampleId> addedSamples;
    private List<ISampleId> removedSamples;
    private List<IExperimentId> addedExperiments;
    private List<IExperimentId> removedExperiments;
    private List<IDataSetId> addedDataSets;
    private List<IDataSetId> removedDataSets;
    private List<IMaterialId> addedMaterials;
    private List<IMaterialId> removedMaterials;

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setAddedEntities(Collection<? extends IObjectId> addedEntities) {
        this.addedSamples = Collections.unmodifiableList(BasicMetaprojectUpdates.filterSamples(addedEntities));
        this.addedDataSets = Collections.unmodifiableList(BasicMetaprojectUpdates.filterDataSets(addedEntities));
        this.addedExperiments = Collections.unmodifiableList(BasicMetaprojectUpdates.filterExperiments(addedEntities));
        this.addedMaterials = Collections.unmodifiableList(BasicMetaprojectUpdates.filterMaterials(addedEntities));
    }

    public void setRemovedEntities(Collection<? extends IObjectId> removedEntities) {
        this.removedSamples = Collections.unmodifiableList(BasicMetaprojectUpdates.filterSamples(removedEntities));
        this.removedDataSets = Collections.unmodifiableList(BasicMetaprojectUpdates.filterDataSets(removedEntities));
        this.removedExperiments = Collections.unmodifiableList(BasicMetaprojectUpdates.filterExperiments(removedEntities));
        this.removedMaterials = Collections.unmodifiableList(BasicMetaprojectUpdates.filterMaterials(removedEntities));
    }

    public List<ISampleId> getAddedSamples() {
        return this.addedSamples;
    }

    public List<ISampleId> getRemovedSamples() {
        return this.removedSamples;
    }

    public List<IExperimentId> getAddedExperiments() {
        return this.addedExperiments;
    }

    public List<IExperimentId> getRemovedExperiments() {
        return this.removedExperiments;
    }

    public List<IDataSetId> getAddedDataSets() {
        return this.addedDataSets;
    }

    public List<IDataSetId> getRemovedDataSets() {
        return this.removedDataSets;
    }

    public List<IMaterialId> getAddedMaterials() {
        return this.addedMaterials;
    }

    public List<IMaterialId> getRemovedMaterials() {
        return this.removedMaterials;
    }

    public static LinkedList<ISampleId> filterSamples(Collection<? extends IObjectId> entities) {
        LinkedList<ISampleId> list = new LinkedList<ISampleId>();
        for (IObjectId iObjectId : entities) {
            if (!(iObjectId instanceof ISampleId)) continue;
            list.add((ISampleId)iObjectId);
        }
        return list;
    }

    public static LinkedList<IExperimentId> filterExperiments(Collection<? extends IObjectId> entities) {
        LinkedList<IExperimentId> list = new LinkedList<IExperimentId>();
        for (IObjectId iObjectId : entities) {
            if (!(iObjectId instanceof IExperimentId)) continue;
            list.add((IExperimentId)iObjectId);
        }
        return list;
    }

    public static LinkedList<IDataSetId> filterDataSets(Collection<? extends IObjectId> entities) {
        LinkedList<IDataSetId> list = new LinkedList<IDataSetId>();
        for (IObjectId iObjectId : entities) {
            if (!(iObjectId instanceof IDataSetId)) continue;
            list.add((IDataSetId)iObjectId);
        }
        return list;
    }

    public static LinkedList<IMaterialId> filterMaterials(Collection<? extends IObjectId> entities) {
        LinkedList<IMaterialId> list = new LinkedList<IMaterialId>();
        for (IObjectId iObjectId : entities) {
            if (!(iObjectId instanceof IMaterialId)) continue;
            list.add((IMaterialId)iObjectId);
        }
        return list;
    }
}

