/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic.dto;

import ch.systemsx.cisd.common.parser.BeanProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.ICodeHolder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;

public class Code<T extends Code<T>>
implements Serializable,
ICodeHolder,
Comparable<T> {
    private static final long serialVersionUID = 35L;
    public static final String CODE = "code";
    public static final Comparator<ICodeHolder> CODE_PROVIDER_COMPARATOR = new CodeProviderComparator();
    private String code;

    @BeanProperty(label="code")
    public final void setCode(String code) {
        this.code = code;
    }

    @Override
    public final String getCode() {
        return this.code;
    }

    @Override
    public final int compareTo(T o) {
        return CODE_PROVIDER_COMPARATOR.compare(this, (ICodeHolder)o);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Code)) {
            return false;
        }
        Code that = (Code)obj;
        return this.getCode().equals(that.getCode());
    }

    public int hashCode() {
        return this.getCode().hashCode();
    }

    public String toString() {
        return this.getCode();
    }

    public static final List<String> extractCodes(Collection<? extends ICodeHolder> codeProviders) {
        ArrayList<String> codes = new ArrayList<String>();
        if (codeProviders != null) {
            for (ICodeHolder iCodeHolder : codeProviders) {
                codes.add(iCodeHolder.getCode());
            }
        }
        return codes;
    }

    public static final List<String> extractCodes(ICodeHolder[] codeProviders) {
        ArrayList<String> codes = new ArrayList<String>();
        if (codeProviders != null) {
            for (ICodeHolder codeProvider : codeProviders) {
                codes.add(codeProvider.getCode());
            }
        }
        return codes;
    }

    public static final String[] extractCodesToArray(Collection<? extends ICodeHolder> codeProviders) {
        int size = codeProviders == null ? 0 : codeProviders.size();
        return Code.extractCodes(codeProviders).toArray(new String[size]);
    }

    private static final class CodeProviderComparator
    implements Comparator<ICodeHolder>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private CodeProviderComparator() {
        }

        @Override
        public int compare(ICodeHolder o1, ICodeHolder o2) {
            assert (o1 != null) : "Unspecified code provider.";
            assert (o2 != null) : "Unspecified code provider.";
            String thisCode = o1.getCode();
            String thatCode = o2.getCode();
            if (thisCode == null) {
                return thatCode == null ? 0 : -1;
            }
            if (thatCode == null) {
                return 1;
            }
            return thisCode.compareTo(thatCode);
        }
    }
}

