/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic.dto;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CompareType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchField;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;

public class DetailedSearchCriterion
implements Serializable {
    private static final long serialVersionUID = 35L;
    public static final String SERVER_TIMEZONE = "server";
    private DetailedSearchField field;
    private CompareType type;
    private Collection<String> values;
    private String timezone;
    private boolean negated;

    public DetailedSearchCriterion() {
    }

    public DetailedSearchCriterion(DetailedSearchField field, String value) {
        this.field = field;
        this.values = Arrays.asList(value);
        this.type = CompareType.EQUALS;
    }

    public DetailedSearchCriterion(DetailedSearchField field, Collection<String> values) {
        this.field = field;
        this.values = values;
        this.type = CompareType.EQUALS;
    }

    public DetailedSearchCriterion(DetailedSearchField field, CompareType type, String date) {
        this(field, type, date, SERVER_TIMEZONE);
    }

    public DetailedSearchCriterion(DetailedSearchField field, CompareType type, Number value) {
        this.field = field;
        this.values = Arrays.asList(value.toString());
        this.type = type;
    }

    public DetailedSearchCriterion(DetailedSearchField field, CompareType type, String value, String timezoneOrNull) {
        this.field = field;
        this.values = Arrays.asList(value);
        this.type = type;
        this.timezone = timezoneOrNull;
    }

    public DetailedSearchField getField() {
        return this.field;
    }

    public void setField(DetailedSearchField field) {
        this.field = field;
    }

    public String getValue() {
        return this.values != null && this.values.size() > 0 ? this.values.iterator().next() : null;
    }

    public void setValue(String value) {
        this.values = Arrays.asList(value);
    }

    public Collection<String> getValues() {
        return this.values;
    }

    public void setValues(Collection<String> values) {
        this.values = values;
    }

    public CompareType getType() {
        return this.type;
    }

    public String getTimeZone() {
        return this.timezone;
    }

    public boolean isNegated() {
        return this.negated;
    }

    public DetailedSearchCriterion negate() {
        this.negated = true;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.negated) {
            sb.append("not ");
        }
        sb.append(this.getField());
        sb.append(": ");
        if (this.values == null || this.values.size() == 1) {
            sb.append(this.getValue());
        } else {
            sb.append(this.getValues().toString());
        }
        return sb.toString();
    }
}

