/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic.dto;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISerializableComparable;

public class EntityTableCell
implements ISerializableComparable {
    private static final String MISSING_ENTITY_SUFFIX = " (missing)";
    private static final long serialVersionUID = 35L;
    private EntityKind entityKind;
    private String permId;
    private String identifierOrNull;
    private String linkTextOrNull;
    private boolean invalid = false;
    private boolean fake = false;

    public EntityTableCell(EntityKind entityKind, String permId) {
        this(entityKind, permId, permId);
    }

    public EntityTableCell(EntityKind entityKind, String permId, String identifierOrNull) {
        if (entityKind == null) {
            throw new IllegalArgumentException("Unspecified entityKind");
        }
        if (permId == null) {
            throw new IllegalArgumentException("Unspecified permId");
        }
        this.entityKind = entityKind;
        this.permId = permId;
        this.identifierOrNull = identifierOrNull;
    }

    @Override
    public int compareTo(ISerializableComparable o) {
        return this.toString().compareTo(o.toString());
    }

    public EntityKind getEntityKind() {
        return this.entityKind;
    }

    public String getPermId() {
        return this.permId;
    }

    public String getIdentifierOrNull() {
        return this.identifierOrNull;
    }

    public boolean isMissing() {
        return this.identifierOrNull == null;
    }

    public int hashCode() {
        return this.getPermId().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof EntityTableCell)) {
            return false;
        }
        EntityTableCell otherCell = (EntityTableCell)obj;
        return this.entityKind.equals(otherCell.entityKind) && this.permId.equals(otherCell.permId);
    }

    private String createLinkText() {
        if (this.isMissing()) {
            return (this.linkTextOrNull != null ? this.linkTextOrNull : this.permId) + MISSING_ENTITY_SUFFIX;
        }
        return this.linkTextOrNull != null ? this.linkTextOrNull : this.identifierOrNull;
    }

    public void setLinkText(String linkText) {
        this.linkTextOrNull = linkText;
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public void setInvalid(boolean invalid) {
        this.invalid = invalid;
    }

    public boolean isFake() {
        return this.fake;
    }

    public void setFake(boolean fake) {
        this.fake = fake;
    }

    public String toString() {
        return this.createLinkText();
    }

    private EntityTableCell() {
    }
}

