/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic.dto;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BasicEntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Code;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Script;
import java.io.Serializable;
import java.util.Date;

public abstract class EntityTypePropertyType<T extends EntityType>
implements Serializable,
Comparable<EntityTypePropertyType<T>> {
    private static final long serialVersionUID = 35L;
    private EntityKind entityKind;
    private boolean mandatory;
    private boolean managedInternally;
    private Long ordinal;
    private String section;
    private PropertyType propertyType;
    private T entityType;
    private boolean dynamic;
    private boolean managed;
    private boolean showInEditView;
    private boolean showRawValue;
    private Script script;
    private Date modificationDate;

    public Date getModificationDate() {
        return this.modificationDate;
    }

    public void setModificationDate(Date modificationDate) {
        this.modificationDate = modificationDate;
    }

    public Script getScript() {
        return this.script;
    }

    public void setScript(Script script) {
        this.script = script;
    }

    public EntityTypePropertyType(EntityKind entityKind) {
        this.entityKind = entityKind;
    }

    public EntityKind getEntityKind() {
        return this.entityKind;
    }

    public final boolean isDynamic() {
        return this.dynamic;
    }

    public final void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public final boolean isManaged() {
        return this.managed;
    }

    public final void setManaged(boolean managed) {
        this.managed = managed;
    }

    public final boolean isShownInEditView() {
        if (this.isDynamic()) {
            return false;
        }
        return this.showInEditView;
    }

    public final void setShownInEditView(boolean showInEditView) {
        this.showInEditView = showInEditView;
    }

    public boolean getShowRawValue() {
        return this.showRawValue;
    }

    public void setShowRawValue(boolean showRawValue) {
        this.showRawValue = showRawValue;
    }

    public final boolean isMandatory() {
        return this.mandatory;
    }

    public final void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    public final boolean isManagedInternally() {
        return this.managedInternally;
    }

    public final void setManagedInternally(boolean managedInternally) {
        this.managedInternally = managedInternally;
    }

    public final PropertyType getPropertyType() {
        return this.propertyType;
    }

    public final void setPropertyType(PropertyType propertyType) {
        this.propertyType = propertyType;
    }

    public final T getEntityType() {
        return this.entityType;
    }

    public final void setEntityType(T entityType) {
        this.entityType = entityType;
    }

    public Long getOrdinal() {
        return this.ordinal;
    }

    public void setOrdinal(Long ordinal) {
        this.ordinal = ordinal;
    }

    public String getSection() {
        return this.section;
    }

    public void setSection(String section) {
        this.section = section;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof EntityTypePropertyType)) {
            return false;
        }
        EntityTypePropertyType that = (EntityTypePropertyType)obj;
        return this.getPropertyType().equals(that.getPropertyType());
    }

    public int hashCode() {
        return this.getPropertyType().hashCode();
    }

    @Override
    public final int compareTo(EntityTypePropertyType<T> o) {
        assert (o != null) : "Unspecified entity type property type.";
        T entityType1 = this.getEntityType();
        T entityType2 = o.getEntityType();
        Long ordinal1 = this.getOrdinal();
        Long ordinal2 = o.getOrdinal();
        if (((BasicEntityType)entityType1).equals(entityType2)) {
            return ordinal1.compareTo(ordinal2);
        }
        return ((Code)entityType1).compareTo(entityType2);
    }
}

