/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic.dto;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ContainerDataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatasetLocation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IDatasetLocation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IDatasetLocationNode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PhysicalDataSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;

public class ExternalDataLocationNode
implements IDatasetLocationNode {
    private final AbstractExternalData externalData;
    private final Integer orderInParentContainer;

    public ExternalDataLocationNode(AbstractExternalData externalData) {
        this(externalData, null);
    }

    private ExternalDataLocationNode(AbstractExternalData externalData, Integer orderInParentContainer) {
        if (externalData == null) {
            throw new IllegalArgumentException("ExternalData cannot be null");
        }
        this.externalData = externalData;
        this.orderInParentContainer = orderInParentContainer;
    }

    @Override
    public IDatasetLocation getLocation() {
        DatasetLocation datasetLocation = new DatasetLocation();
        datasetLocation.setDatasetCode(this.externalData.getCode());
        PhysicalDataSet dataSet = this.externalData.tryGetAsDataSet();
        datasetLocation.setDataSetLocation(dataSet == null ? null : dataSet.getLocation());
        datasetLocation.setDataStoreCode(this.externalData.getDataStore().getCode());
        datasetLocation.setDataStoreUrl(this.externalData.getDataStore().getHostUrl());
        datasetLocation.setOrderInContainer(this.orderInParentContainer);
        return datasetLocation;
    }

    @Override
    public boolean isContainer() {
        return this.externalData.isContainer();
    }

    @Override
    public Collection<IDatasetLocationNode> getComponents() {
        if (!this.isContainer()) {
            return Collections.emptyList();
        }
        ContainerDataSet container = this.externalData.tryGetAsContainerDataSet();
        List<AbstractExternalData> components = container.getContainedDataSets();
        if (components != null) {
            TreeMap<String, ExternalDataLocationNode> componentsLocationNodes = new TreeMap<String, ExternalDataLocationNode>();
            String containerCode = container.getCode();
            for (AbstractExternalData component : components) {
                componentsLocationNodes.put(component.getCode(), new ExternalDataLocationNode(component, component.getOrderInContainer(containerCode)));
            }
            return componentsLocationNodes.values();
        }
        return Collections.emptyList();
    }
}

