/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic.dto;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewMaterialsWithTypes;
import java.util.List;

public class MaterialBatchUpdateResultMessage {
    private String message;

    public MaterialBatchUpdateResultMessage(List<NewMaterialsWithTypes> materials, int updateCount, boolean ignoreUnregisteredMaterials) {
        this.message = updateCount + " material(s) updated";
        if (ignoreUnregisteredMaterials) {
            int ignoredCount = -updateCount;
            for (NewMaterialsWithTypes m : materials) {
                ignoredCount += m.getNewEntities().size();
            }
            this.message = ignoredCount > 0 ? this.message + ", " + ignoredCount + " ignored." : this.message + ", non ignored.";
        } else {
            this.message = this.message + ".";
        }
    }

    public String toString() {
        return this.message;
    }
}

