/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic.dto;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetArchivingStatus;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.FileFormatType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IDatasetLocation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.LocatorType;

public class PhysicalDataSet
extends AbstractExternalData
implements IDatasetLocation {
    private static final long serialVersionUID = 35L;
    private Boolean complete;
    private boolean presentInArchive;
    private String shareId;
    private String location;
    private DataSetArchivingStatus status;
    private int speedHint;
    private LocatorType locatorType;
    private FileFormatType fileFormatType;
    private boolean h5Folders;
    private boolean h5arFolders;
    private boolean archivingRequested;

    public PhysicalDataSet() {
        this(false);
    }

    public PhysicalDataSet(boolean isStub) {
        super(isStub);
    }

    @Override
    public PhysicalDataSet tryGetAsDataSet() {
        return this;
    }

    @Override
    public Long getDataSetSize() {
        return this.getSize();
    }

    public Boolean getComplete() {
        return this.complete;
    }

    public void setComplete(Boolean complete) {
        this.complete = complete;
    }

    public void setShareId(String shareId) {
        this.shareId = shareId;
    }

    public String getShareId() {
        return this.shareId;
    }

    public String getLocation() {
        return this.location;
    }

    public String getFullLocation() {
        if (this.shareId != null && this.status.isAvailable()) {
            return this.shareId + "/" + this.location;
        }
        return "-";
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public DataSetArchivingStatus getStatus() {
        return this.status;
    }

    public void setStatus(DataSetArchivingStatus status) {
        this.status = status;
    }

    public boolean isPresentInArchive() {
        return this.presentInArchive;
    }

    public void setPresentInArchive(boolean presentInArchive) {
        this.presentInArchive = presentInArchive;
    }

    public int getSpeedHint() {
        return this.speedHint;
    }

    public void setSpeedHint(int speedHint) {
        this.speedHint = speedHint;
    }

    public LocatorType getLocatorType() {
        return this.locatorType;
    }

    public void setLocatorType(LocatorType locatorType) {
        this.locatorType = locatorType;
    }

    public FileFormatType getFileFormatType() {
        return this.fileFormatType;
    }

    public void setFileFormatType(FileFormatType fileFormatType) {
        this.fileFormatType = fileFormatType;
    }

    @Override
    public boolean isAvailable() {
        return this.getStatus().isAvailable();
    }

    @Override
    public String getDataSetLocation() {
        return this.getLocation();
    }

    @Override
    public String getDataSetCode() {
        return this.getCode();
    }

    @Override
    public String getDataStoreUrl() {
        return this.getDataStore().getHostUrl();
    }

    @Override
    public String getDataStoreCode() {
        return this.getDataStore().getCode();
    }

    public boolean isH5Folders() {
        return this.h5Folders;
    }

    public void setH5Folders(boolean h5Folders) {
        this.h5Folders = h5Folders;
    }

    public boolean isH5arFolders() {
        return this.h5arFolders;
    }

    public void setH5arFolders(boolean h5arFolders) {
        this.h5arFolders = h5arFolders;
    }

    public boolean isArchivingRequested() {
        return this.archivingRequested;
    }

    public void setArchivingRequested(boolean archivingRequested) {
        this.archivingRequested = archivingRequested;
    }
}

