/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic.dto;

import ch.systemsx.cisd.common.reflection.CollectionMapping;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleTypePropertyType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public final class SampleType
extends EntityType
implements Serializable {
    private static final long serialVersionUID = 35L;
    private Long id;
    private boolean showParents;
    private boolean showContainer;
    private boolean listable;
    private boolean subcodeUnique;
    private boolean autoGeneratedCode;
    private boolean showParentMetadata;
    private String generatedCodePrefix;
    private List<SampleTypePropertyType> sampleTypePropertyTypes = new ArrayList<SampleTypePropertyType>(0);

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public final int getGeneratedFromHierarchyDepth() {
        return this.isShowParents() ? 1 : 0;
    }

    public final void setGeneratedFromHierarchyDepth(int generatedFromHierarchyDepth) {
        this.setShowParents(generatedFromHierarchyDepth > 0);
    }

    public final void setShowParents(boolean showParents) {
        this.showParents = showParents;
    }

    public final boolean isShowParents() {
        return this.showParents;
    }

    public final int getContainerHierarchyDepth() {
        return this.isShowContainer() ? 1 : 0;
    }

    public final void setContainerHierarchyDepth(int partOfHierarchyDepth) {
        this.setShowContainer(partOfHierarchyDepth > 0);
    }

    public final void setShowContainer(boolean showContainer) {
        this.showContainer = showContainer;
    }

    public final boolean isShowContainer() {
        return this.showContainer;
    }

    public final List<SampleTypePropertyType> getAssignedPropertyTypes() {
        return this.sampleTypePropertyTypes;
    }

    @CollectionMapping(collectionClass=ArrayList.class, elementClass=SampleTypePropertyType.class)
    public final void setSampleTypePropertyTypes(List<SampleTypePropertyType> sampleTypePropertyTypes) {
        this.sampleTypePropertyTypes = sampleTypePropertyTypes;
    }

    public final boolean isListable() {
        return this.listable;
    }

    public final void setListable(boolean listable) {
        this.listable = listable;
    }

    public final boolean isSubcodeUnique() {
        return this.subcodeUnique;
    }

    public final void setSubcodeUnique(boolean subcodeUnique) {
        this.subcodeUnique = subcodeUnique;
    }

    public final boolean isAutoGeneratedCode() {
        return this.autoGeneratedCode;
    }

    public final void setAutoGeneratedCode(boolean autoGeneratedCode) {
        this.autoGeneratedCode = autoGeneratedCode;
    }

    public boolean isShowParentMetadata() {
        return this.showParentMetadata;
    }

    public void setShowParentMetadata(boolean showParentMetadata) {
        this.showParentMetadata = showParentMetadata;
    }

    public String getGeneratedCodePrefix() {
        return this.generatedCodePrefix;
    }

    public void setGeneratedCodePrefix(String generatedCodePrefix) {
        this.generatedCodePrefix = generatedCodePrefix;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SampleType)) {
            return false;
        }
        SampleType that = (SampleType)obj;
        return this.getGeneratedFromHierarchyDepth() == that.getGeneratedFromHierarchyDepth() && this.getContainerHierarchyDepth() == that.getContainerHierarchyDepth();
    }

    public static final SampleType createAllSampleType(Collection<SampleType> sampleTypes, boolean withDetails) {
        assert (sampleTypes != null);
        SampleType allSampleType = new SampleType();
        allSampleType.setCode("(all)");
        allSampleType.setListable(true);
        SampleType.setupMaxHierarchyDepth(allSampleType, sampleTypes);
        if (withDetails) {
            SampleType.mergeDetails(allSampleType, sampleTypes);
        }
        return allSampleType;
    }

    private static void setupMaxHierarchyDepth(SampleType allSampleType, Collection<SampleType> sampleTypes) {
        int maxContainerHierarchyDepth = 0;
        int maxGeneratedFromHierarchyDepth = 0;
        for (SampleType sampleType : sampleTypes) {
            maxContainerHierarchyDepth = SampleType.max(maxContainerHierarchyDepth, sampleType.getContainerHierarchyDepth());
            maxGeneratedFromHierarchyDepth = SampleType.max(maxGeneratedFromHierarchyDepth, sampleType.getGeneratedFromHierarchyDepth());
        }
        allSampleType.setContainerHierarchyDepth(maxContainerHierarchyDepth);
        allSampleType.setGeneratedFromHierarchyDepth(maxGeneratedFromHierarchyDepth);
    }

    private static int max(int a, int b) {
        return a >= b ? a : b;
    }

    private static void mergeDetails(SampleType allSampleType, Collection<SampleType> sampleTypes) {
        HashSet<SampleTypePropertyType> allPropertyTypes = new HashSet<SampleTypePropertyType>();
        for (SampleType sampleType : sampleTypes) {
            allPropertyTypes.addAll(sampleType.getAssignedPropertyTypes());
        }
        allSampleType.setSampleTypePropertyTypes(new ArrayList<SampleTypePropertyType>(allPropertyTypes));
    }

    @Override
    public boolean isEntityKind(EntityKind kind) {
        return kind == null || kind == EntityKind.SAMPLE;
    }

    @Override
    public EntityKind getEntityKind() {
        return EntityKind.SAMPLE;
    }
}

