/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic.dto;

import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISerializableComparable;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SerializableComparableIDDecorator;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRow;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class TableModelRowWithObject<T extends Serializable>
extends TableModelRow
implements IIdHolder {
    private static final long serialVersionUID = 35L;
    private T objectOrNull;
    private Long id;

    public static <T extends Serializable> List<T> getObjects(List<TableModelRowWithObject<T>> rows) {
        ArrayList<T> list = new ArrayList<T>();
        for (TableModelRowWithObject<T> row : rows) {
            list.add(row.getObjectOrNull());
        }
        return list;
    }

    public TableModelRowWithObject(T objectOrNull, List<ISerializableComparable> values) {
        super(values);
        this.objectOrNull = objectOrNull;
        if (objectOrNull instanceof IIdHolder) {
            this.id = ((IIdHolder)objectOrNull).getId();
        } else {
            for (ISerializableComparable value : values) {
                if (!(value instanceof SerializableComparableIDDecorator)) continue;
                this.id = ((SerializableComparableIDDecorator)value).getID();
                break;
            }
        }
    }

    private TableModelRowWithObject() {
    }

    public T getObjectOrNull() {
        return this.objectOrNull;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.objectOrNull == null ? 0 : this.objectOrNull.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableModelRowWithObject)) {
            return false;
        }
        TableModelRowWithObject other = (TableModelRowWithObject)obj;
        if (this.id == null ? other.id != null : false == this.id.equals(other.id)) {
            return false;
        }
        return !(this.objectOrNull == null ? other.objectOrNull != null : false == this.objectOrNull.equals(other.objectOrNull));
    }
}

