/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic.dto.builders;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.builders.PropertyBuilder;
import java.util.ArrayList;
import java.util.List;

public class MaterialBuilder {
    private final Material material = new Material();

    public MaterialBuilder() {
        this.material.setProperties(new ArrayList<IEntityProperty>());
    }

    public final Material getMaterial() {
        return this.material;
    }

    public MaterialBuilder id(Long id) {
        this.material.setId(id);
        return this;
    }

    public MaterialBuilder code(String code) {
        this.material.setCode(code);
        return this;
    }

    public MaterialBuilder type(String type) {
        MaterialType materialType = new MaterialType();
        materialType.setCode(type);
        this.material.setMaterialType(materialType);
        return this;
    }

    public PropertyBuilder property(String key) {
        List<IEntityProperty> properties = this.material.getProperties();
        PropertyBuilder propertyBuilder = new PropertyBuilder(key);
        properties.add(propertyBuilder.getProperty());
        return propertyBuilder;
    }

    public MaterialBuilder property(String key, String value) {
        this.property(key).value(value);
        return this;
    }
}

