/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic.dto.builders;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.builders.MaterialBuilder;
import java.text.SimpleDateFormat;
import java.util.Date;

public class PropertyBuilder {
    private final ExtendedEntityProperty property = new ExtendedEntityProperty();

    public PropertyBuilder(String key) {
        PropertyType propertyType = new PropertyType();
        propertyType.setCode(key);
        propertyType.setSimpleCode(key);
        this.property.setPropertyType(propertyType);
        this.type(DataTypeCode.VARCHAR);
    }

    public PropertyBuilder type(DataTypeCode dataType) {
        this.property.getPropertyType().setDataType(new DataType(dataType));
        return this;
    }

    public PropertyBuilder label(String label) {
        this.property.getPropertyType().setLabel(label);
        return this;
    }

    public PropertyBuilder internal() {
        PropertyType propertyType = this.property.getPropertyType();
        propertyType.setManagedInternally(true);
        propertyType.setCode("$" + propertyType.getSimpleCode());
        return this;
    }

    public PropertyBuilder dynamic() {
        this.property.setDynamic(true);
        return this;
    }

    public PropertyBuilder managed() {
        this.property.setManaged(true);
        return this;
    }

    public PropertyBuilder value(String value) {
        this.property.setValue(value);
        return this;
    }

    public PropertyBuilder value(int value) {
        this.type(DataTypeCode.INTEGER);
        this.property.setValue(Integer.toString(value));
        return this;
    }

    public PropertyBuilder value(double value) {
        this.type(DataTypeCode.REAL);
        this.property.setValue(Double.toString(value));
        return this;
    }

    public PropertyBuilder value(Date value) {
        this.type(DataTypeCode.TIMESTAMP);
        String formatedDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z").format(value);
        this.property.setValue(formatedDate);
        return this;
    }

    public PropertyBuilder value(MaterialBuilder builder) {
        return this.value(builder.getMaterial());
    }

    public PropertyBuilder value(Material value) {
        this.type(DataTypeCode.MATERIAL);
        this.property.setMaterial(value);
        return this;
    }

    public PropertyBuilder value(VocabularyTerm value) {
        this.type(DataTypeCode.CONTROLLEDVOCABULARY);
        this.property.setVocabularyTerm(value);
        return this;
    }

    public EntityProperty getProperty() {
        return this.property;
    }

    private static final class ExtendedEntityProperty
    extends EntityProperty {
        private static final long serialVersionUID = 35L;
        private boolean managed;

        private ExtendedEntityProperty() {
        }

        @Override
        public boolean isManaged() {
            return this.managed;
        }

        void setManaged(boolean managed) {
            this.managed = managed;
        }
    }
}

