/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import java.io.Serializable;

public class AtomicEntityOperationResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final long spacesCreatedCount;
    private final long projectsCreatedCount;
    private final long projectsUpdatedCount;
    private final long materialsCreatedCount;
    private final long materialsUpdatedCount;
    private final long experimentsCreatedCount;
    private final long experimentsUpdatedCount;
    private final long samplesCreatedCount;
    private final long samplesUpdatedCount;
    private final long dataSetsCreatedCount;
    private final long dataSetsUpdatedCount;
    private final long metaprojectsCreatedCount;
    private final long metaprojectsUpdatedCount;
    private final long vocabulariesUpdatedCount;
    private final long spaceRolesAssignedCount;
    private final long spaceRolesRevokedCount;

    public AtomicEntityOperationResult() {
        this(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
    }

    public AtomicEntityOperationResult(long spacesCreated, long projectsCreated, long projectsUpdated, long materialsCreated, long materialsUpdated, long experimentsCreated, long experimentsUpdated, long samplesCreated, long samplesUpdated, long dataSetsCreated, long dataSetsUpdated, long metaprojectsCreatedCount, long metaprojectsUpdatedCount, long vocabulariesUpdatedCount, long spaceRolesAssignedCount, long spaceRolesRevokedCount) {
        this.spacesCreatedCount = spacesCreated;
        this.projectsCreatedCount = projectsCreated;
        this.projectsUpdatedCount = projectsUpdated;
        this.materialsCreatedCount = materialsCreated;
        this.materialsUpdatedCount = materialsUpdated;
        this.experimentsCreatedCount = experimentsCreated;
        this.experimentsUpdatedCount = experimentsUpdated;
        this.samplesCreatedCount = samplesCreated;
        this.samplesUpdatedCount = samplesUpdated;
        this.dataSetsCreatedCount = dataSetsCreated;
        this.dataSetsUpdatedCount = dataSetsUpdated;
        this.metaprojectsCreatedCount = metaprojectsCreatedCount;
        this.metaprojectsUpdatedCount = metaprojectsUpdatedCount;
        this.vocabulariesUpdatedCount = vocabulariesUpdatedCount;
        this.spaceRolesAssignedCount = spaceRolesAssignedCount;
        this.spaceRolesRevokedCount = spaceRolesRevokedCount;
    }

    public long getExperimentsUpdatedCount() {
        return this.experimentsUpdatedCount;
    }

    public long getExperimentsCreatedCount() {
        return this.experimentsCreatedCount;
    }

    public long getSamplesUpdatedCount() {
        return this.samplesUpdatedCount;
    }

    public long getSamplesCreatedCount() {
        return this.samplesCreatedCount;
    }

    public long getDataSetsCreatedCount() {
        return this.dataSetsCreatedCount;
    }

    public long getDataSetsUpdatedCount() {
        return this.dataSetsUpdatedCount;
    }

    public long getSpacesCreatedCount() {
        return this.spacesCreatedCount;
    }

    public long getProjectsCreatedCount() {
        return this.projectsCreatedCount;
    }

    public long getProjectsUpdatedCount() {
        return this.projectsUpdatedCount;
    }

    public long getMaterialsCreatedCount() {
        return this.materialsCreatedCount;
    }

    public long getMaterialsUpdatedCount() {
        return this.materialsUpdatedCount;
    }

    public long getMetaprojectsCreatedCount() {
        return this.metaprojectsCreatedCount;
    }

    public long getMetaprojectsUpdatedCount() {
        return this.metaprojectsUpdatedCount;
    }

    public long getVocabulariesUpdatedCount() {
        return this.vocabulariesUpdatedCount;
    }

    private long getAllOperationsCount() {
        return this.spacesCreatedCount + this.projectsCreatedCount + this.projectsUpdatedCount + this.materialsCreatedCount + this.materialsUpdatedCount + this.experimentsCreatedCount + this.experimentsUpdatedCount + this.samplesCreatedCount + this.samplesUpdatedCount + this.dataSetsCreatedCount + this.dataSetsUpdatedCount + this.metaprojectsCreatedCount + this.metaprojectsUpdatedCount + this.vocabulariesUpdatedCount;
    }

    public long getSpaceRolesAssignedCount() {
        return this.spaceRolesAssignedCount;
    }

    public long getSpaceRolesRevokedCount() {
        return this.spaceRolesRevokedCount;
    }

    public String toString() {
        if (this.getAllOperationsCount() == 0L) {
            return "No entities have been created or updated";
        }
        StringBuilder message = new StringBuilder();
        message.append("Total of " + this.getAllOperationsCount() + " entities have been created or updated.\n");
        this.updateMessage(message, this.spacesCreatedCount, "Spaces created");
        this.updateMessage(message, this.projectsCreatedCount, "Projects created");
        this.updateMessage(message, this.projectsUpdatedCount, "Projects updated");
        this.updateMessage(message, this.materialsCreatedCount, "Materials created");
        this.updateMessage(message, this.materialsUpdatedCount, "Materials updated");
        this.updateMessage(message, this.experimentsCreatedCount, "Experiments created");
        this.updateMessage(message, this.experimentsUpdatedCount, "Experiments updated");
        this.updateMessage(message, this.samplesCreatedCount, "Samples created");
        this.updateMessage(message, this.samplesUpdatedCount, "Samples updated");
        this.updateMessage(message, this.dataSetsCreatedCount, "Data sets created");
        this.updateMessage(message, this.dataSetsUpdatedCount, "Data sets updated");
        this.updateMessage(message, this.metaprojectsCreatedCount, "Metaprojects created");
        this.updateMessage(message, this.metaprojectsUpdatedCount, "Metaprojects updated");
        this.updateMessage(message, this.vocabulariesUpdatedCount, "Vocabularies updated");
        this.updateMessage(message, this.spaceRolesAssignedCount, "Space roles assigned");
        this.updateMessage(message, this.spaceRolesRevokedCount, "Space roles revoked");
        return message.toString();
    }

    private void updateMessage(StringBuilder builder, long count, String msg) {
        if (count > 0L) {
            builder.append(msg + ": " + count + "\n");
        }
    }
}

