/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.systemsx.cisd.openbis.generic.shared.dto.ExternalDataManagementSystemPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.HibernateAbstractRegistrationHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.LinkDataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.LocationType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;

@Entity
@Table(name="content_copies")
public class ContentCopyPE
extends HibernateAbstractRegistrationHolder {
    private static final long serialVersionUID = 1L;
    private Long id;
    private LinkDataPE dataSet;
    private ExternalDataManagementSystemPE externalDataManagementSystem;
    private LocationType locationType;
    private String externalCode;
    private String path;
    private String gitCommitHash;
    private String gitRepositoryId;
    private boolean dataSetFrozen;

    @Id
    @SequenceGenerator(name="CONTENT_COPIES_ID_SEQ", sequenceName="CONTENT_COPIES_ID_SEQ", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="CONTENT_COPIES_ID_SEQ")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @NotNull
    @Column(name="data_frozen", nullable=false)
    public boolean isDataSetFrozen() {
        return this.dataSetFrozen;
    }

    public void setDataSetFrozen(boolean dataSetFrozen) {
        this.dataSetFrozen = dataSetFrozen;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="data_id", updatable=true)
    public LinkDataPE getDataSet() {
        return this.dataSet;
    }

    public void setDataSet(LinkDataPE dataSet) {
        this.dataSet = dataSet;
        if (dataSet != null) {
            this.dataSetFrozen = dataSet.isFrozen();
        }
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @NotNull(message="External data management system can not be null.")
    @JoinColumn(name="edms_id", updatable=true)
    public ExternalDataManagementSystemPE getExternalDataManagementSystem() {
        return this.externalDataManagementSystem;
    }

    public void setExternalDataManagementSystem(ExternalDataManagementSystemPE externalDataManagementSystem) {
        this.externalDataManagementSystem = externalDataManagementSystem;
    }

    @Column(name="location_type", nullable=false)
    @Enumerated(value=EnumType.STRING)
    public LocationType getLocationType() {
        return this.locationType;
    }

    public void setLocationType(LocationType locationType) {
        this.locationType = locationType;
    }

    @Column(name="external_code")
    public String getExternalCode() {
        return this.externalCode;
    }

    public void setExternalCode(String externalCode) {
        this.externalCode = externalCode;
    }

    @Column(name="path")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @Column(name="git_commit_hash")
    public String getGitCommitHash() {
        return this.gitCommitHash;
    }

    public void setGitCommitHash(String gitCommitHash) {
        this.gitCommitHash = gitCommitHash;
    }

    @Column(name="git_repository_id")
    public String getGitRepositoryId() {
        return this.gitRepositoryId;
    }

    public void setGitRepositoryId(String gitRepositoryId) {
        this.gitRepositoryId = gitRepositoryId;
    }
}

