/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.systemsx.cisd.common.collection.UnmodifiableSetDecorator;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdentifierHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdentityHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.AbstractIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetPropertyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetRelationshipPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataStorePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DeletionPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityPropertyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExternalDataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.HibernateAbstractRegistrationHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.IDeletablePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.IEntityInformationWithPropertiesHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.IEntityWithMetaprojects;
import ch.systemsx.cisd.openbis.generic.shared.dto.IMatchingEntity;
import ch.systemsx.cisd.openbis.generic.shared.dto.IModifierAndModificationDateBean;
import ch.systemsx.cisd.openbis.generic.shared.dto.LinkDataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MetaprojectAssignmentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MetaprojectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PostRegistrationPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;
import org.hibernate.annotations.OptimisticLock;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="data", uniqueConstraints={@UniqueConstraint(columnNames={"code"})})
@Inheritance(strategy=InheritanceType.JOINED)
public class DataPE
extends AbstractIdAndCodeHolder<DataPE>
implements IEntityInformationWithPropertiesHolder,
IMatchingEntity,
IIdentifierHolder,
IDeletablePE,
IEntityWithMetaprojects,
IModifierAndModificationDateBean,
IIdentityHolder {
    private static final long serialVersionUID = 35L;
    public static final DataPE[] EMPTY_ARRAY = new DataPE[0];
    private transient Long id;
    private String code;
    private boolean frozen;
    private boolean frozenForChildren;
    private boolean frozenForParents;
    private boolean frozenForComponents;
    private boolean frozenForContainers;
    private boolean isDerived;
    private PersonPE registrator;
    private PersonPE modifier;
    private Date registrationDate;
    private DataSetTypePE dataSetType;
    private String dataSetKind = "PHYSICAL";
    private ExperimentPE experiment;
    private boolean experimentFrozen;
    private SamplePE sample;
    private boolean sampleFrozen;
    private Date productionDate;
    private Date modificationDate;
    private Date accessDate;
    private int version;
    private String dataProducerCode;
    private Set<MetaprojectAssignmentPE> metaprojectAssignments = new HashSet<MetaprojectAssignmentPE>();
    private Set<PostRegistrationPE> postRegistration = new HashSet<PostRegistrationPE>();
    private DeletionPE deletion;
    private Integer originalDeletion;
    private DataStorePE dataStore;
    private Set<DataSetRelationshipPE> parentRelationships = new LinkedHashSet<DataSetRelationshipPE>();
    private Set<DataSetRelationshipPE> childRelationships = new LinkedHashSet<DataSetRelationshipPE>();
    private Set<DataSetPropertyPE> properties = new HashSet<DataSetPropertyPE>();

    @OptimisticLock(excluded=true)
    @OneToMany(fetch=FetchType.LAZY, mappedBy="parentDataSet")
    @Fetch(value=FetchMode.SUBSELECT)
    private Set<DataSetRelationshipPE> getDataSetChildRelationships() {
        return this.childRelationships;
    }

    private void setDataSetChildRelationships(Set<DataSetRelationshipPE> childRelationships) {
        this.childRelationships = childRelationships;
    }

    @Transient
    public Set<DataSetRelationshipPE> getChildRelationships() {
        return new UnmodifiableSetDecorator<DataSetRelationshipPE>(this.getDataSetChildRelationships());
    }

    public void addChildRelationship(DataSetRelationshipPE relationship) {
        relationship.setParentDataSet(this);
        this.getDataSetChildRelationships().add(relationship);
    }

    @OptimisticLock(excluded=true)
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="childDataSet", orphanRemoval=true)
    @Fetch(value=FetchMode.SUBSELECT)
    private Set<DataSetRelationshipPE> getDataSetParentRelationships() {
        return this.parentRelationships;
    }

    private void setDataSetParentRelationships(Set<DataSetRelationshipPE> parentRelationships) {
        this.parentRelationships = parentRelationships;
    }

    @Transient
    public Set<DataSetRelationshipPE> getParentRelationships() {
        return new UnmodifiableSetDecorator<DataSetRelationshipPE>(this.getDataSetParentRelationships());
    }

    @Transient
    public boolean isParentRelationshipsInitialized() {
        return HibernateUtils.isInitialized(this.getDataSetParentRelationships());
    }

    @Transient
    public boolean isChildrenRelationshipsInitialized() {
        return HibernateUtils.isInitialized(this.getDataSetChildRelationships());
    }

    public void setParentRelationships(Set<DataSetRelationshipPE> parentRelationships) {
        this.getDataSetParentRelationships().clear();
        for (DataSetRelationshipPE dataSetRelationship : parentRelationships) {
            DataPE parent = dataSetRelationship.getChildDataSet();
            if (parent != null) {
                parent.getDataSetParentRelationships().remove(dataSetRelationship);
            }
            this.addParentRelationship(dataSetRelationship);
        }
    }

    @Transient
    public List<DataPE> getContainers() {
        Set<DataSetRelationshipPE> relationships = this.getParentRelationships();
        ArrayList<DataPE> containers = new ArrayList<DataPE>();
        for (DataSetRelationshipPE r : relationships) {
            if (!this.isContainerComponentRelationship(r)) continue;
            assert (r.getChildDataSet().equals(this));
            containers.add(r.getParentDataSet());
        }
        return containers;
    }

    public void addParentRelationship(DataSetRelationshipPE relationship) {
        relationship.setChildDataSet(this);
        this.getDataSetParentRelationships().add(relationship);
    }

    public void removeParentRelationship(DataSetRelationshipPE relationship) {
        this.getDataSetParentRelationships().remove(relationship);
        relationship.getParentDataSet().getDataSetChildRelationships().remove(relationship);
        relationship.setChildDataSet(null);
        relationship.setParentDataSet(null);
    }

    @Transient
    public List<DataPE> getParents() {
        Set<DataSetRelationshipPE> relationships = this.getParentRelationships();
        ArrayList<DataPE> parents = new ArrayList<DataPE>();
        for (DataSetRelationshipPE r : relationships) {
            if (!this.isParentChildRelationship(r)) continue;
            assert (r.getChildDataSet().equals(this));
            parents.add(r.getParentDataSet());
        }
        return parents;
    }

    @Transient
    public List<DataPE> getChildren() {
        Set<DataSetRelationshipPE> relationships = this.getChildRelationships();
        ArrayList<DataPE> children = new ArrayList<DataPE>();
        for (DataSetRelationshipPE r : relationships) {
            if (!this.isParentChildRelationship(r)) continue;
            assert (r.getParentDataSet().equals(this));
            children.add(r.getChildDataSet());
        }
        return children;
    }

    @Transient
    public Collection<DataPE> getLinkedDataSets() {
        HashSet<DataPE> set = new HashSet<DataPE>();
        for (DataSetRelationshipPE relationship : this.getParentRelationships()) {
            set.add(relationship.getParentDataSet());
        }
        for (DataSetRelationshipPE relationship : this.getChildRelationships()) {
            set.add(relationship.getChildDataSet());
        }
        return set;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @NotNull(message="Data store can not be null.")
    @JoinColumn(name="dast_id", updatable=false)
    public DataStorePE getDataStore() {
        return this.dataStore;
    }

    public void setDataStore(DataStorePE dataStorePE) {
        this.dataStore = dataStorePE;
    }

    @Override
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="pers_id_registerer", updatable=false)
    public PersonPE getRegistrator() {
        return this.registrator;
    }

    public void setRegistrator(PersonPE registrator) {
        this.registrator = registrator;
    }

    @Override
    @OptimisticLock(excluded=true)
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="pers_id_modifier")
    public PersonPE getModifier() {
        return this.modifier;
    }

    @Override
    public void setModifier(PersonPE modifier) {
        this.modifier = modifier;
    }

    @Column(name="registration_timestamp", nullable=false, insertable=false)
    @Generated(value=GenerationTime.ALWAYS)
    public Date getRegistrationDate() {
        return HibernateAbstractRegistrationHolder.getDate(this.registrationDate);
    }

    public void setRegistrationDate(Date registrationDate) {
        this.registrationDate = registrationDate;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @NotNull(message="Data set type can not be null.")
    @JoinColumn(name="dsty_id")
    public DataSetTypePE getDataSetType() {
        return this.dataSetType;
    }

    public void setDataSetType(DataSetTypePE dataSetType) {
        this.dataSetType = dataSetType;
    }

    @Column(name="data_set_kind", nullable=false)
    public String getDataSetKind() {
        return this.dataSetKind;
    }

    public void setDataSetKind(String dataSetKind) {
        this.dataSetKind = dataSetKind;
    }

    @NotNull
    @Column(name="frozen", nullable=false)
    public boolean isFrozen() {
        return this.frozen;
    }

    public void setFrozen(boolean frozen) {
        this.frozen = frozen;
    }

    @NotNull
    @Column(name="frozen_for_children", nullable=false)
    public boolean isFrozenForChildren() {
        return this.frozenForChildren;
    }

    public void setFrozenForChildren(boolean frozenForChildren) {
        this.frozenForChildren = frozenForChildren;
    }

    @NotNull
    @Column(name="frozen_for_parents", nullable=false)
    public boolean isFrozenForParents() {
        return this.frozenForParents;
    }

    public void setFrozenForParents(boolean frozenForParents) {
        this.frozenForParents = frozenForParents;
    }

    @NotNull
    @Column(name="frozen_for_comps", nullable=false)
    public boolean isFrozenForComponents() {
        return this.frozenForComponents;
    }

    public void setFrozenForComponents(boolean frozenForComponents) {
        this.frozenForComponents = frozenForComponents;
    }

    @NotNull
    @Column(name="frozen_for_conts", nullable=false)
    public boolean isFrozenForContainers() {
        return this.frozenForContainers;
    }

    public void setFrozenForContainers(boolean frozenForContainers) {
        this.frozenForContainers = frozenForContainers;
    }

    @Column(name="is_derived")
    public boolean isDerived() {
        return this.isDerived;
    }

    public void setDerived(boolean isDerived) {
        this.isDerived = isDerived;
    }

    private boolean isContainerComponentRelationship(DataSetRelationshipPE relationship) {
        return relationship.getRelationshipType().getCode().equals("$CONTAINER_COMPONENT");
    }

    private boolean isParentChildRelationship(DataSetRelationshipPE relationship) {
        return relationship.getRelationshipType().getCode().equals("$PARENT_CHILD");
    }

    @Transient
    public boolean isMeasured() {
        return !this.isDerived;
    }

    public void setSampleAcquiredFrom(SamplePE sample) {
        this.setDerived(false);
        this.setSample(sample);
    }

    public void setSample(SamplePE sample) {
        if (sample != null) {
            sample.addDataSet(this);
        } else {
            SamplePE previousSample = this.tryGetSample();
            if (previousSample != null) {
                previousSample.removeDataSet(this);
            }
        }
    }

    @Transient
    public SamplePE tryGetSample() {
        return this.getSampleInternal();
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="samp_id")
    private SamplePE getSampleInternal() {
        return this.sample;
    }

    void setSampleInternal(SamplePE sample) {
        this.sample = sample;
        if (sample != null) {
            this.sampleFrozen = sample.isFrozen() && sample.isFrozenForDataSet();
        }
    }

    @Transient
    private Long getSampleId() {
        Long result = null;
        if (this.getSampleInternal() != null) {
            result = HibernateUtils.getId(this.getSampleInternal());
            assert (result != null);
        }
        return result;
    }

    @NotNull
    @Column(name="samp_frozen", nullable=false)
    public boolean isSampleFrozen() {
        if (this.sample != null) {
            this.sampleFrozen = this.sample.isFrozen() && this.sample.isFrozenForDataSet();
        }
        return this.sampleFrozen;
    }

    public void setSampleFrozen(boolean sampleFrozen) {
        this.sampleFrozen = sampleFrozen;
    }

    @Column(name="production_timestamp")
    public Date getProductionDate() {
        return HibernateAbstractRegistrationHolder.getDate(this.productionDate);
    }

    public void setProductionDate(Date productionDate) {
        this.productionDate = productionDate;
    }

    @Length(min=1, max=100, message="Given code '%s' is either too short (minimal length: {min} character) or too long (maximal length: {max} characters).")
    @Column(name="data_producer_code")
    public String getDataProducerCode() {
        return this.dataProducerCode;
    }

    public void setDataProducerCode(String dataProducerCode) {
        this.dataProducerCode = dataProducerCode;
    }

    @Version
    @Column(name="version", nullable=false)
    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    @Override
    @OptimisticLock(excluded=true)
    @Column(name="modification_timestamp", nullable=false)
    public Date getModificationDate() {
        return this.modificationDate;
    }

    @Override
    public void setModificationDate(Date versionDate) {
        this.modificationDate = versionDate;
    }

    @Column(name="access_timestamp", nullable=false, insertable=false)
    @Generated(value=GenerationTime.ALWAYS)
    public Date getAccessDate() {
        return this.accessDate;
    }

    public void setAccessDate(Date versionDate) {
        this.accessDate = versionDate;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Transient
    public List<DataPE> getContainedDataSets() {
        TreeMap<Double, DataPE> sortedContained = new TreeMap<Double, DataPE>();
        if (this.childRelationships != null) {
            for (DataSetRelationshipPE relationship : this.childRelationships) {
                if (!this.isContainerComponentRelationship(relationship)) continue;
                Integer ordinal = relationship.getOrdinal();
                DataPE component = relationship.getChildDataSet();
                if (ordinal == null) {
                    throw new IllegalStateException("Container data set '" + this.getCode() + "' has component '" + component.getCode() + "' with unspecified order in container.");
                }
                sortedContained.put((double)ordinal.intValue() + 1.0 / (double)Math.max(2L, component.getId()), component);
            }
        }
        return new ArrayList<DataPE>(sortedContained.values());
    }

    @Override
    @Id
    @SequenceGenerator(name="DATA_ID_SEQ", sequenceName="DATA_ID_SEQ", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="DATA_ID_SEQ")
    public Long getId() {
        return this.id;
    }

    @Override
    @Column(unique=true)
    @NotNull(message="Code can not be null.")
    @Length(min=1, max=100, message="Given code '%s' is either too short (minimal length: {min} character) or too long (maximal length: {max} characters).")
    @Pattern(regexp="^[A-Z0-9_\\-\\.]+$", flags={Pattern.Flag.CASE_INSENSITIVE}, message="Given code '%s' contains illegal characters (allowed: A-Z, a-z, 0-9 and _, -, .)")
    public String getCode() {
        return this.code;
    }

    public void setExperiment(ExperimentPE experiment) {
        if (experiment != null) {
            experiment.addDataSet(this);
        } else {
            ExperimentPE previous = this.getExperiment();
            if (previous != null) {
                previous.removeDataSet(this);
            }
            this.setExperimentInternal(null);
        }
    }

    @Transient
    public ExperimentPE getExperiment() {
        return this.getExperimentInternal();
    }

    void setExperimentInternal(ExperimentPE experiment) {
        this.experiment = experiment;
        if (experiment != null) {
            this.experimentFrozen = experiment.isFrozen() && experiment.isFrozenForDataSet();
        }
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="expe_id", updatable=true)
    private ExperimentPE getExperimentInternal() {
        return this.experiment;
    }

    @Transient
    private Long getExperimentId() {
        Long result = null;
        if (this.getExperimentInternal() != null) {
            result = HibernateUtils.getId(this.getExperimentInternal());
            assert (result != null);
        }
        return result;
    }

    @NotNull
    @Column(name="expe_frozen", nullable=false)
    public boolean isExperimentFrozen() {
        if (this.experiment != null) {
            this.experimentFrozen = this.experiment.isFrozen() && this.experiment.isFrozenForDataSet();
        }
        return this.experimentFrozen;
    }

    public void setExperimentFrozen(boolean experimentFrozen) {
        this.experimentFrozen = experimentFrozen;
    }

    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="entity", orphanRemoval=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @BatchSize(size=100)
    private Set<DataSetPropertyPE> getDataSetProperties() {
        return this.properties;
    }

    private void setDataSetProperties(Set<DataSetPropertyPE> properties) {
        this.properties = properties;
    }

    @Override
    public void setProperties(Set<? extends EntityPropertyPE> properties) {
        this.getDataSetProperties().clear();
        for (EntityPropertyPE entityPropertyPE : properties) {
            DataSetPropertyPE property = (DataSetPropertyPE)entityPropertyPE;
            DataPE parent = property.getEntity();
            if (parent != null) {
                parent.getDataSetProperties().remove(property);
            }
            this.addProperty(property);
        }
    }

    @Override
    public void addProperty(EntityPropertyPE property) {
        property.setEntity(this);
        property.setEntityFrozen(this.isFrozen());
        this.getDataSetProperties().add((DataSetPropertyPE)property);
    }

    @Override
    public void removeProperty(EntityPropertyPE property) {
        this.getDataSetProperties().remove(property);
        property.setEntity(null);
    }

    @Transient
    public Set<DataSetPropertyPE> getProperties() {
        return new UnmodifiableSetDecorator<DataSetPropertyPE>(this.getDataSetProperties());
    }

    @Override
    @Transient
    public boolean isPropertiesInitialized() {
        return HibernateUtils.isInitialized(this.getDataSetProperties());
    }

    @Override
    @Transient
    public EntityKind getEntityKind() {
        return EntityKind.DATA_SET;
    }

    @Override
    @Transient
    public EntityTypePE getEntityType() {
        return this.getDataSetType();
    }

    @Override
    @Transient
    public String getIdentifier() {
        return this.getCode();
    }

    @Override
    @Transient
    public String getPermId() {
        return this.code;
    }

    @Transient
    public boolean isContainer() {
        return this.tryAsExternalData() == null && !this.isLinkData();
    }

    @Transient
    public boolean isExternalData() {
        return !this.isContainer() && !this.isLinkData();
    }

    @Transient
    public ExternalDataPE tryAsExternalData() {
        return this instanceof ExternalDataPE ? (ExternalDataPE)this : null;
    }

    @Transient
    public boolean isLinkData() {
        return false;
    }

    @Transient
    public LinkDataPE tryAsLinkData() {
        return null;
    }

    @Transient
    public boolean isAvailable() {
        return false;
    }

    @Transient
    public boolean isDeletable() {
        return true;
    }

    @Transient
    public SpacePE getSpace() {
        if (this.experiment != null) {
            return this.experiment.getProject().getSpace();
        }
        return this.sample == null ? null : this.sample.getSpace();
    }

    @Transient
    public ProjectPE getProject() {
        if (this.experiment != null) {
            return this.experiment.getProject();
        }
        if (this.sample != null) {
            return this.sample.getExperiment() != null ? this.sample.getExperiment().getProject() : this.sample.getProject();
        }
        return null;
    }

    @Transient
    private Long getSpaceId() {
        Long result = null;
        if (this.getSpace() != null) {
            result = HibernateUtils.getId(this.getSpace());
            assert (result != null);
        }
        return result;
    }

    @Override
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="del_id")
    public DeletionPE getDeletion() {
        return this.deletion;
    }

    public void setDeletion(DeletionPE deletion) {
        this.deletion = deletion;
    }

    @Column(name="orig_del", nullable=false)
    public Integer getOriginalDeletion() {
        return this.originalDeletion;
    }

    public void setOriginalDeletion(Integer originalDeletion) {
        this.originalDeletion = originalDeletion;
    }

    @Override
    public void addMetaproject(MetaprojectPE metaprojectPE) {
        if (metaprojectPE == null) {
            throw new IllegalArgumentException("Metaproject cannot be null");
        }
        MetaprojectAssignmentPE assignmentPE = new MetaprojectAssignmentPE();
        assignmentPE.setMetaproject(metaprojectPE);
        assignmentPE.setDataSet(this);
        this.getMetaprojectAssignmentsInternal().add(assignmentPE);
        metaprojectPE.getAssignmentsInternal().add(assignmentPE);
    }

    @Override
    public void removeMetaproject(MetaprojectPE metaprojectPE) {
        if (metaprojectPE == null) {
            throw new IllegalArgumentException("Metaproject cannot be null");
        }
        MetaprojectAssignmentPE assignmentPE = new MetaprojectAssignmentPE();
        assignmentPE.setMetaproject(metaprojectPE);
        assignmentPE.setDataSet(this);
        this.getMetaprojectAssignmentsInternal().remove(assignmentPE);
        metaprojectPE.getAssignmentsInternal().remove(assignmentPE);
    }

    @Override
    @Transient
    public Set<MetaprojectPE> getMetaprojects() {
        HashSet<MetaprojectPE> metaprojects = new HashSet<MetaprojectPE>();
        for (MetaprojectAssignmentPE assignment : this.getMetaprojectAssignmentsInternal()) {
            metaprojects.add(assignment.getMetaproject());
        }
        return new UnmodifiableSetDecorator<MetaprojectPE>((Set<MetaprojectPE>)metaprojects);
    }

    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="dataSet")
    @Fetch(value=FetchMode.SUBSELECT)
    private Set<MetaprojectAssignmentPE> getMetaprojectAssignmentsInternal() {
        return this.metaprojectAssignments;
    }

    private void setMetaprojectAssignmentsInternal(Set<MetaprojectAssignmentPE> metaprojectAssignments) {
        this.metaprojectAssignments = metaprojectAssignments;
    }

    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="dataSet")
    @Fetch(value=FetchMode.SUBSELECT)
    public Set<PostRegistrationPE> getPostRegistration() {
        return this.postRegistration;
    }

    public void setPostRegistration(Set<PostRegistrationPE> postRegistration) {
        this.postRegistration = postRegistration;
    }
}

