/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import javax.persistence.Entity;
import javax.persistence.EntityResult;
import javax.persistence.Id;
import javax.persistence.NamedNativeQueries;
import javax.persistence.NamedNativeQuery;
import javax.persistence.SqlResultSetMapping;
import javax.persistence.Transient;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

@Entity
@SqlResultSetMapping(name="dataset_access_implicit", entities={@EntityResult(entityClass=DataSetAccessPE.class)})
@NamedNativeQueries(value={@NamedNativeQuery(name="dataset_access_by_tech_ids", query="SELECT d.id as dataSetId, d.code as dataSetCode, ep.code as experimentProjectCode, es.code as experimentSpaceCode, ss.code as sampleSpaceCode, sep.code as sampleExperimentProjectCode, ses.code as sampleExperimentSpaceCode, sp.code as sampleProjectCode, sps.code as sampleProjectSpaceCode FROM data d left outer join experiments_all e on d.expe_id = e.id left outer join projects ep on e.proj_id = ep.id left outer join spaces es on ep.space_id = es.id left outer join samples_all s on d.samp_id = s.id left outer join spaces ss on s.space_id = ss.id left outer join experiments_all se on s.expe_id = se.id left outer join projects sep on se.proj_id = sep.id left outer join spaces ses on sep.space_id = ses.id left outer join projects sp on s.proj_id = sp.id left outer join spaces sps on sp.space_id = sps.id WHERE d.id in (:ids)", resultSetMapping="dataset_access_implicit"), @NamedNativeQuery(name="dataset_access_by_codes", query="SELECT d.id as dataSetId, d.code as dataSetCode, ep.code as experimentProjectCode, es.code as experimentSpaceCode, ss.code as sampleSpaceCode, sep.code as sampleExperimentProjectCode, ses.code as sampleExperimentSpaceCode, sp.code as sampleProjectCode, sps.code as sampleProjectSpaceCode FROM data d left outer join experiments_all e on d.expe_id = e.id left outer join projects ep on e.proj_id = ep.id left outer join spaces es on ep.space_id = es.id left outer join samples_all s on d.samp_id = s.id left outer join spaces ss on s.space_id = ss.id left outer join experiments_all se on s.expe_id = se.id left outer join projects sep on se.proj_id = sep.id left outer join spaces ses on sep.space_id = ses.id left outer join projects sp on s.proj_id = sp.id left outer join spaces sps on sp.space_id = sps.id WHERE d.code in (:codes)", resultSetMapping="dataset_access_implicit"), @NamedNativeQuery(name="deleted_dataset_access", query="SELECT d.id as dataSetId, d.code as dataSetCode, ep.code as experimentProjectCode, es.code as experimentSpaceCode, ss.code as sampleSpaceCode, sep.code as sampleExperimentProjectCode, ses.code as sampleExperimentSpaceCode, sp.code as sampleProjectCode, sps.code as sampleProjectSpaceCode FROM data_deleted d left outer join experiments_all e on d.expe_id = e.id left outer join projects ep on e.proj_id = ep.id left outer join spaces es on ep.space_id = es.id left outer join samples_all s on d.samp_id = s.id left outer join spaces ss on s.space_id = ss.id left outer join experiments_all se on s.expe_id = se.id left outer join projects sep on se.proj_id = sep.id left outer join spaces ses on sep.space_id = ses.id left outer join projects sp on s.proj_id = sp.id left outer join spaces sps on sp.space_id = sps.id WHERE d.del_id in (:del_ids)", resultSetMapping="dataset_access_implicit")})
public class DataSetAccessPE {
    private static final String DATASET_ACCESS_QUERY_PART_1 = "SELECT d.id as dataSetId, d.code as dataSetCode, ep.code as experimentProjectCode, es.code as experimentSpaceCode, ss.code as sampleSpaceCode, sep.code as sampleExperimentProjectCode, ses.code as sampleExperimentSpaceCode, sp.code as sampleProjectCode, sps.code as sampleProjectSpaceCode FROM ";
    private static final String DATASET_ACCESS_QUERY_PART_2 = " d left outer join experiments_all e on d.expe_id = e.id left outer join projects ep on e.proj_id = ep.id left outer join spaces es on ep.space_id = es.id left outer join samples_all s on d.samp_id = s.id left outer join spaces ss on s.space_id = ss.id left outer join experiments_all se on s.expe_id = se.id left outer join projects sep on se.proj_id = sep.id left outer join spaces ses on sep.space_id = ses.id left outer join projects sp on s.proj_id = sp.id left outer join spaces sps on sp.space_id = sps.id ";
    public static final String DATASET_ACCESS_BY_TECH_IDS_QUERY = "SELECT d.id as dataSetId, d.code as dataSetCode, ep.code as experimentProjectCode, es.code as experimentSpaceCode, ss.code as sampleSpaceCode, sep.code as sampleExperimentProjectCode, ses.code as sampleExperimentSpaceCode, sp.code as sampleProjectCode, sps.code as sampleProjectSpaceCode FROM data d left outer join experiments_all e on d.expe_id = e.id left outer join projects ep on e.proj_id = ep.id left outer join spaces es on ep.space_id = es.id left outer join samples_all s on d.samp_id = s.id left outer join spaces ss on s.space_id = ss.id left outer join experiments_all se on s.expe_id = se.id left outer join projects sep on se.proj_id = sep.id left outer join spaces ses on sep.space_id = ses.id left outer join projects sp on s.proj_id = sp.id left outer join spaces sps on sp.space_id = sps.id WHERE d.id in (:ids)";
    public static final String DATASET_ACCESS_BY_CODES_QUERY = "SELECT d.id as dataSetId, d.code as dataSetCode, ep.code as experimentProjectCode, es.code as experimentSpaceCode, ss.code as sampleSpaceCode, sep.code as sampleExperimentProjectCode, ses.code as sampleExperimentSpaceCode, sp.code as sampleProjectCode, sps.code as sampleProjectSpaceCode FROM data d left outer join experiments_all e on d.expe_id = e.id left outer join projects ep on e.proj_id = ep.id left outer join spaces es on ep.space_id = es.id left outer join samples_all s on d.samp_id = s.id left outer join spaces ss on s.space_id = ss.id left outer join experiments_all se on s.expe_id = se.id left outer join projects sep on se.proj_id = sep.id left outer join spaces ses on sep.space_id = ses.id left outer join projects sp on s.proj_id = sp.id left outer join spaces sps on sp.space_id = sps.id WHERE d.code in (:codes)";
    public static final String DELETED_DATASET_ACCESS_QUERY = "SELECT d.id as dataSetId, d.code as dataSetCode, ep.code as experimentProjectCode, es.code as experimentSpaceCode, ss.code as sampleSpaceCode, sep.code as sampleExperimentProjectCode, ses.code as sampleExperimentSpaceCode, sp.code as sampleProjectCode, sps.code as sampleProjectSpaceCode FROM data_deleted d left outer join experiments_all e on d.expe_id = e.id left outer join projects ep on e.proj_id = ep.id left outer join spaces es on ep.space_id = es.id left outer join samples_all s on d.samp_id = s.id left outer join spaces ss on s.space_id = ss.id left outer join experiments_all se on s.expe_id = se.id left outer join projects sep on se.proj_id = sep.id left outer join spaces ses on sep.space_id = ses.id left outer join projects sp on s.proj_id = sp.id left outer join spaces sps on sp.space_id = sps.id WHERE d.del_id in (:del_ids)";
    public static final String DATASET_ACCESS_BY_TECH_IDS_QUERY_NAME = "dataset_access_by_tech_ids";
    public static final String DATASET_ACCESS_BY_CODES_QUERY_NAME = "dataset_access_by_codes";
    public static final String DELETED_DATASET_ACCESS_QUERY_NAME = "deleted_dataset_access";
    public static final String DATA_SET_IDS_PARAMETER_NAME = "ids";
    public static final String DATA_SET_CODES_PARAMETER_NAME = "codes";
    public static final String DELETION_IDS_PARAMETER_NAME = "del_ids";
    public static final String RESULT_SET_MAPPING = "dataset_access_implicit";
    private Long dataSetId;
    private String dataSetCode;
    private String experimentProjectCode;
    private String experimentSpaceCode;
    private String sampleSpaceCode;
    private String sampleExperimentProjectCode;
    private String sampleExperimentSpaceCode;
    private String sampleProjectCode;
    private String sampleProjectSpaceCode;
    private boolean group;

    public static DataSetAccessPE createDataSetAccessPEForTest(String dataSetId, String dataSetCode, String groupCode) {
        DataSetAccessPE newMe = new DataSetAccessPE();
        newMe.setExperimentSpaceCode(groupCode);
        return newMe;
    }

    @Transient
    public SpaceIdentifier getSpaceIdentifier() {
        if (this.getExperimentSpaceCode() != null) {
            return new SpaceIdentifier(this.getExperimentSpaceCode());
        }
        if (this.getSampleSpaceCode() != null) {
            return new SpaceIdentifier(this.getSampleSpaceCode());
        }
        if (this.getSampleProjectSpaceCode() != null) {
            return new SpaceIdentifier(this.getSampleProjectSpaceCode());
        }
        if (this.getSampleExperimentSpaceCode() != null) {
            return new SpaceIdentifier(this.getSampleExperimentSpaceCode());
        }
        return null;
    }

    @Transient
    public ProjectIdentifier getProjectIdentifier() {
        if (this.getExperimentSpaceCode() != null && this.getExperimentProjectCode() != null) {
            return new ProjectIdentifier(this.getExperimentSpaceCode(), this.getExperimentProjectCode());
        }
        if (this.getSampleExperimentSpaceCode() != null && this.getSampleExperimentProjectCode() != null) {
            return new ProjectIdentifier(this.getSampleExperimentSpaceCode(), this.getSampleExperimentProjectCode());
        }
        if (this.getSampleProjectSpaceCode() != null && this.getSampleProjectCode() != null) {
            return new ProjectIdentifier(this.getSampleProjectSpaceCode(), this.getSampleProjectCode());
        }
        return null;
    }

    @Id
    public Long getDataSetId() {
        return this.dataSetId;
    }

    public void setDataSetId(Long dataSetId) {
        this.dataSetId = dataSetId;
    }

    public String getDataSetCode() {
        return this.dataSetCode;
    }

    public void setDataSetCode(String dataSetCode) {
        this.dataSetCode = dataSetCode;
    }

    public String getExperimentProjectCode() {
        return this.experimentProjectCode;
    }

    public void setExperimentProjectCode(String experimentProjectCode) {
        this.experimentProjectCode = experimentProjectCode;
    }

    public String getExperimentSpaceCode() {
        return this.experimentSpaceCode;
    }

    public void setExperimentSpaceCode(String experimentSpaceCode) {
        this.experimentSpaceCode = experimentSpaceCode;
    }

    public String getSampleSpaceCode() {
        return this.sampleSpaceCode;
    }

    public void setSampleSpaceCode(String sampleSpaceCode) {
        this.sampleSpaceCode = sampleSpaceCode;
    }

    public String getSampleExperimentProjectCode() {
        return this.sampleExperimentProjectCode;
    }

    public void setSampleExperimentProjectCode(String sampleExperimentProjectCode) {
        this.sampleExperimentProjectCode = sampleExperimentProjectCode;
    }

    public String getSampleExperimentSpaceCode() {
        return this.sampleExperimentSpaceCode;
    }

    public void setSampleExperimentSpaceCode(String sampleExperimentSpaceCode) {
        this.sampleExperimentSpaceCode = sampleExperimentSpaceCode;
    }

    public String getSampleProjectCode() {
        return this.sampleProjectCode;
    }

    public void setSampleProjectCode(String sampleProjectCode) {
        this.sampleProjectCode = sampleProjectCode;
    }

    public String getSampleProjectSpaceCode() {
        return this.sampleProjectSpaceCode;
    }

    public void setSampleProjectSpaceCode(String sampleProjectSpaceCode) {
        this.sampleProjectSpaceCode = sampleProjectSpaceCode;
    }

    public void setGroup(boolean group) {
        this.group = group;
    }

    @Transient
    public boolean isGroup() {
        return this.group;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DataSetAccessPE)) {
            return false;
        }
        DataSetAccessPE that = (DataSetAccessPE)obj;
        EqualsBuilder builder = new EqualsBuilder();
        if (this.isGroup()) {
            builder.append((Object)this.getDataSetCode(), (Object)that.getDataSetCode());
            builder.append((Object)this.getExperimentProjectCode(), (Object)that.getExperimentProjectCode());
            builder.append((Object)this.getExperimentSpaceCode(), (Object)that.getExperimentSpaceCode());
            builder.append((Object)this.getSampleSpaceCode(), (Object)that.getSampleSpaceCode());
            builder.append((Object)this.getSampleExperimentProjectCode(), (Object)that.getSampleExperimentProjectCode());
            builder.append((Object)this.getSampleExperimentSpaceCode(), (Object)that.getSampleExperimentSpaceCode());
            builder.append((Object)this.getSampleProjectCode(), (Object)that.getSampleProjectCode());
            builder.append((Object)this.getSampleProjectSpaceCode(), (Object)that.getSampleProjectSpaceCode());
        } else {
            builder.append((Object)this.getDataSetId(), (Object)that.getDataSetId());
        }
        return builder.isEquals();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        if (this.isGroup()) {
            builder.append((Object)this.getDataSetCode());
            builder.append((Object)this.getExperimentProjectCode());
            builder.append((Object)this.getExperimentSpaceCode());
            builder.append((Object)this.getSampleSpaceCode());
            builder.append((Object)this.getSampleExperimentProjectCode());
            builder.append((Object)this.getSampleExperimentSpaceCode());
            builder.append((Object)this.getSampleProjectCode());
            builder.append((Object)this.getSampleProjectSpaceCode());
        } else {
            builder.append((Object)this.getDataSetId());
        }
        return builder.toHashCode();
    }
}

