/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.dbmigration.DatabaseConfigurationContext;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DataSourceDefinition
implements Serializable,
Cloneable {
    private static final String DEFINITIONS_DELIM = "\n";
    private static final String ATTRIBUTE_DELIM = "\t";
    private static final long serialVersionUID = 35L;
    private String code;
    private String driverClassName;
    private String hostPart;
    private String sid;
    private String username;
    private String password;

    public static DataSourceDefinition createFromContext(DatabaseConfigurationContext context) {
        DataSourceDefinition definition = new DataSourceDefinition();
        definition.setDriverClassName(context.getDatabaseEngine().getDriverClass());
        definition.setHostPart(context.getUrlHostPart());
        definition.setSid(context.getDatabaseName());
        definition.setUsername(context.getOwner());
        definition.setPassword(context.getPassword());
        return definition;
    }

    public static List<DataSourceDefinition> listFromString(String serializedDefinitions) {
        ArrayList<DataSourceDefinition> result = new ArrayList<DataSourceDefinition>();
        if (!StringUtils.isBlank((CharSequence)serializedDefinitions)) {
            String[] definitions;
            for (String definition : definitions = serializedDefinitions.split(DEFINITIONS_DELIM)) {
                result.add(DataSourceDefinition.fromString(definition));
            }
        }
        return result;
    }

    public static String toString(List<DataSourceDefinition> definitions) {
        StringBuilder builder = new StringBuilder();
        for (DataSourceDefinition definition : definitions) {
            builder.append(definition).append(DEFINITIONS_DELIM);
        }
        return builder.toString();
    }

    public static DataSourceDefinition fromString(String serializedDefinition) {
        String[] split;
        DataSourceDefinition result = new DataSourceDefinition();
        for (String definition : split = serializedDefinition.split(ATTRIBUTE_DELIM)) {
            int indexOfEqualsSign = definition.indexOf(61);
            if (indexOfEqualsSign < 0) {
                throw new IllegalArgumentException("Missing '=': " + definition);
            }
            String key = definition.substring(0, indexOfEqualsSign);
            String value = definition.substring(indexOfEqualsSign + 1);
            String setter = "set" + StringUtils.capitalize((String)key);
            try {
                Method method = DataSourceDefinition.class.getMethod(setter, String.class);
                method.invoke((Object)result, value);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Invalid attribute '" + key + "'.", ex);
            }
        }
        return result;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public String getHostPart() {
        return this.hostPart;
    }

    public void setHostPart(String hostPart) {
        this.hostPart = hostPart;
    }

    public String getSid() {
        return this.sid;
    }

    public void setSid(String sid) {
        this.sid = sid;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public DataSourceDefinition clone() {
        try {
            return (DataSourceDefinition)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DataSourceDefinition)) {
            return false;
        }
        DataSourceDefinition that = (DataSourceDefinition)obj;
        return this.equals(this.code, that.code) && this.equals(this.driverClassName, that.driverClassName) && this.equals(this.hostPart, that.hostPart) && this.equals(this.sid, that.sid) && this.equals(this.username, that.username) && this.equals(this.password, that.password);
    }

    private boolean equals(String thisStringOrNull, String thatStringOrNull) {
        return thisStringOrNull == null ? thisStringOrNull == thatStringOrNull : thisStringOrNull.equals(thatStringOrNull);
    }

    public int hashCode() {
        int sum = this.hashCode(0, this.code);
        sum = this.hashCode(sum, this.driverClassName);
        sum = this.hashCode(sum, this.hostPart);
        sum = this.hashCode(sum, this.sid);
        sum = this.hashCode(sum, this.username);
        sum = this.hashCode(sum, this.password);
        return sum;
    }

    private int hashCode(int sum, String attribute) {
        return attribute == null ? 37 * sum : 37 * sum + attribute.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.add(builder, "code");
        this.add(builder, "driverClassName");
        this.add(builder, "hostPart");
        this.add(builder, "sid");
        this.add(builder, "username");
        this.add(builder, "password");
        return builder.toString();
    }

    private void add(StringBuilder builder, String attributeName) {
        String getter = "get" + StringUtils.capitalize((String)attributeName);
        try {
            Method method = DataSourceDefinition.class.getMethod(getter, new Class[0]);
            Object value = method.invoke((Object)this, new Object[0]);
            if (value != null) {
                builder.append(attributeName).append('=').append(value).append(ATTRIBUTE_DELIM);
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Invalid attribute '" + attributeName + "'.", ex);
        }
    }
}

