/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.reflection.ModifiedShortPrefixToStringStyle;
import ch.systemsx.cisd.openbis.generic.shared.dto.AbstractDeletedEntityPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.util.EqualsHashUtils;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="experiments_deleted")
public class DeletedExperimentPE
extends AbstractDeletedEntityPE {
    private static final long serialVersionUID = 35L;
    private transient Long id;
    private String permIdInternal;
    private ExperimentIdentifier experimentIdentifier;
    private ProjectPE project;
    private ExperimentTypePE experimentType;

    @Override
    @Id
    @SequenceGenerator(name="EXPERIMENT_ID_SEQ", sequenceName="EXPERIMENT_ID_SEQ", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="EXPERIMENT_ID_SEQ")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Override
    @Transient
    public String getPermId() {
        return this.getPermIdInternal();
    }

    @NotNull(message="Code can not be null.")
    @Length(min=1, max=100, message="Given code '%s' is either too short (minimal length: {min} character) or too long (maximal length: {max} characters).")
    @Pattern(regexp="^[A-Z0-9_\\-\\.]+$", flags={Pattern.Flag.CASE_INSENSITIVE}, message="Given code '%s' contains illegal characters (allowed: A-Z, a-z, 0-9 and _, -, .)")
    @Column(name="perm_id", nullable=false)
    private String getPermIdInternal() {
        return this.permIdInternal;
    }

    void setPermIdInternal(String permIdInternal) {
        this.permIdInternal = permIdInternal;
    }

    @Override
    @Transient
    public final EntityTypePE getEntityType() {
        return this.getExperimentType();
    }

    @Override
    @Transient
    public final EntityKind getEntityKind() {
        return EntityKind.EXPERIMENT;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @NotNull(message="Experiment type can not be null.")
    @JoinColumn(name="exty_id", updatable=false)
    public ExperimentTypePE getExperimentType() {
        return this.experimentType;
    }

    public void setExperimentType(ExperimentTypePE experimentType) {
        this.experimentType = experimentType;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @NotNull(message="Project can not be null.")
    @JoinColumn(name="proj_id", updatable=false)
    private ProjectPE getProjectInternal() {
        return this.project;
    }

    @Private
    public void setProjectInternal(ProjectPE project) {
        this.project = project;
    }

    @Transient
    public ProjectPE getProject() {
        return this.getProjectInternal();
    }

    @Override
    @Transient
    public String getIdentifier() {
        if (this.experimentIdentifier == null) {
            this.experimentIdentifier = new ExperimentIdentifier(this.getProject().getIdentifier(), this.getCode());
        }
        return this.experimentIdentifier.toString();
    }

    public final boolean equals(Object obj) {
        EqualsHashUtils.assertDefined(this.getCode(), "code");
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DeletedExperimentPE)) {
            return false;
        }
        DeletedExperimentPE that = (DeletedExperimentPE)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.getCode(), (Object)that.getCode());
        return builder.isEquals();
    }

    @Override
    public final int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getCode());
        return builder.toHashCode();
    }

    @Override
    public final String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ModifiedShortPrefixToStringStyle.MODIFIED_SHORT_PREFIX_STYLE);
        builder.append("code", (Object)this.getCode());
        builder.append("deletion", (Object)this.getDeletion());
        return builder.toString();
    }
}

