/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.systemsx.cisd.common.reflection.ClassUtils;
import ch.systemsx.cisd.common.reflection.ModifiedShortPrefixToStringStyle;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.HibernateAbstractRegistrationHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.IEntityPropertiesHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.IEntityPropertyHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.IUntypedValueSetter;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.VocabularyTermPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.util.EqualsHashUtils;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.Version;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.TypeDef;
import org.hibernate.annotations.TypeDefs;
import org.hibernate.type.DbTimestampType;

@MappedSuperclass
@TypeDefs(value={@TypeDef(name="transactiontimestamp", typeClass=DbTimestampType.class)})
public abstract class EntityPropertyPE
extends HibernateAbstractRegistrationHolder
implements IUntypedValueSetter,
IEntityPropertyHolder {
    private static final long serialVersionUID = 35L;
    protected IEntityPropertiesHolder entity;
    private String value;
    private VocabularyTermPE vocabularyTerm;
    private MaterialPE material;
    protected transient Long id;
    protected EntityTypePropertyTypePE entityTypePropertyType;
    private PersonPE author;
    private Date modificationDate;
    protected boolean entityFrozen;

    public <T extends EntityTypePropertyTypePE> void setEntityTypePropertyType(T entityTypePropertyType) {
        this.entityTypePropertyType = entityTypePropertyType;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setEntityFrozen(boolean frozen) {
        this.entityFrozen = frozen;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Column(name="value")
    public String getValue() {
        return this.value;
    }

    public void setVocabularyTerm(VocabularyTermPE vt) {
        this.vocabularyTerm = vt;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="cvte_id")
    public VocabularyTermPE getVocabularyTerm() {
        return this.vocabularyTerm;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="mate_prop_id")
    public MaterialPE getMaterialValue() {
        return this.material;
    }

    public void setMaterialValue(MaterialPE material) {
        this.material = material;
    }

    @Override
    public void setUntypedValue(String valueOrNull, VocabularyTermPE vocabularyTermOrNull, MaterialPE materialOrNull, SamplePE sampleOrNull) {
        assert (valueOrNull != null || vocabularyTermOrNull != null || materialOrNull != null) : "Either value, vocabulary term or material should not be null.";
        this.setVocabularyTerm(null);
        this.setMaterialValue(null);
        this.setValue(null);
        if (vocabularyTermOrNull != null) {
            assert (materialOrNull == null);
            this.setVocabularyTerm(vocabularyTermOrNull);
        } else if (materialOrNull != null) {
            this.setMaterialValue(materialOrNull);
        } else {
            this.setValue(valueOrNull);
        }
    }

    @Version
    @Column(name="modification_timestamp", nullable=false)
    @Type(type="transactiontimestamp")
    public Date getModificationDate() {
        return this.modificationDate;
    }

    public void setModificationDate(Date versionDate) {
        this.modificationDate = versionDate;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="pers_id_author", nullable=false, updatable=true)
    public PersonPE getAuthor() {
        return this.author;
    }

    public void setAuthor(PersonPE author) {
        this.author = author;
    }

    void setEntity(IEntityPropertiesHolder entity) {
        this.entity = entity;
    }

    public final String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ModifiedShortPrefixToStringStyle.MODIFIED_SHORT_PREFIX_STYLE);
        builder.append("entityTypePropertyType", (Object)this.getEntityTypePropertyType());
        builder.append("value", (Object)this.tryGetUntypedValue());
        return builder.toString();
    }

    @Override
    public String tryGetUntypedValue() {
        if (this.getVocabularyTerm() != null) {
            String labelOrNull = this.getVocabularyTerm().getLabel();
            return this.getVocabularyTerm().getCode() + (labelOrNull != null ? " " + this.getVocabularyTerm().getLabel() : "");
        }
        if (this.getMaterialValue() != null) {
            return EntityPropertyPE.createMaterialIdentifier(this.getMaterialValue()).print();
        }
        return this.getValue();
    }

    private static MaterialIdentifier createMaterialIdentifier(MaterialPE material) {
        return new MaterialIdentifier(material.getCode(), material.getMaterialType().getCode());
    }

    public static final <T extends EntityPropertyPE> T createEntityProperty(EntityKind entityKind) {
        assert (entityKind != null) : "Unspecified entity kind";
        return (T)((EntityPropertyPE)ClassUtils.createInstance(entityKind.getEntityPropertyClass()));
    }

    public final boolean equals(Object obj) {
        EqualsHashUtils.assertDefined(this.getEntityTypePropertyType(), "etpt");
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof EntityPropertyPE)) {
            return false;
        }
        EntityPropertyPE that = (EntityPropertyPE)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.getEntity(), (Object)that.getEntity());
        builder.append((Object)this.getEntityTypePropertyType(), (Object)that.getEntityTypePropertyType());
        return builder.isEquals();
    }

    public final int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getEntity());
        builder.append((Object)this.getEntityTypePropertyType());
        return builder.toHashCode();
    }
}

