/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import javax.persistence.Entity;
import javax.persistence.EntityResult;
import javax.persistence.Id;
import javax.persistence.NamedNativeQueries;
import javax.persistence.NamedNativeQuery;
import javax.persistence.SqlResultSetMapping;
import javax.persistence.Transient;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

@Entity
@SqlResultSetMapping(name="experiment_access_implicit", entities={@EntityResult(entityClass=ExperimentAccessPE.class)})
@NamedNativeQueries(value={@NamedNativeQuery(name="experiment_access", query="SELECT s.code as spaceCode, p.code as projectCode, e.code as experimentCode, e.id as experimentId FROM experiments e inner join projects p on e.proj_id = p.id inner join spaces s on p.space_id = s.id WHERE e.id in (:ids)", resultSetMapping="experiment_access_implicit"), @NamedNativeQuery(name="deleted_experiment_access", query="SELECT s.code as spaceCode, p.code as projectCode, e.code as experimentCode, e.id as experimentId FROM experiments_deleted e inner join projects p on e.proj_id = p.id inner join spaces s on p.space_id = s.id WHERE e.del_id in (:del_ids)", resultSetMapping="experiment_access_implicit")})
public class ExperimentAccessPE {
    public static final String EXPERIMENT_ACCESS_QUERY = "SELECT s.code as spaceCode, p.code as projectCode, e.code as experimentCode, e.id as experimentId FROM experiments e inner join projects p on e.proj_id = p.id inner join spaces s on p.space_id = s.id WHERE e.id in (:ids)";
    public static final String DELETED_EXPERIMENT_ACCESS_QUERY = "SELECT s.code as spaceCode, p.code as projectCode, e.code as experimentCode, e.id as experimentId FROM experiments_deleted e inner join projects p on e.proj_id = p.id inner join spaces s on p.space_id = s.id WHERE e.del_id in (:del_ids)";
    private String spaceCode;
    private String projectCode;
    private String experimentCode;
    private Long experimentId;
    private boolean group;
    public static final String EXPERIMENT_ACCESS_QUERY_NAME = "experiment_access";
    public static final String DELETED_EXPERIMENT_ACCESS_QUERY_NAME = "deleted_experiment_access";
    public static final String EXPERIMENT_IDS_PARAMETER_NAME = "ids";
    public static final String DELETION_IDS_PARAMETER_NAME = "del_ids";
    public static final String RESULT_SET_MAPPING = "experiment_access_implicit";

    void setSpaceCode(String spaceCode) {
        this.spaceCode = spaceCode;
    }

    public String getSpaceCode() {
        return this.spaceCode;
    }

    @Transient
    public SpaceIdentifier getSpaceIdentifier() {
        if (this.getSpaceCode() != null) {
            return new SpaceIdentifier(this.getSpaceCode());
        }
        return null;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    @Transient
    public ProjectIdentifier getProjectIdentifier() {
        if (this.getSpaceCode() != null && this.getProjectCode() != null) {
            return new ProjectIdentifier(this.getSpaceCode(), this.getProjectCode());
        }
        return null;
    }

    public String getProjectCode() {
        return this.projectCode;
    }

    public void setExperimentCode(String experimentCode) {
        this.experimentCode = experimentCode;
    }

    public String getExperimentCode() {
        return this.experimentCode;
    }

    public void setExperimentId(Long experimentId) {
        this.experimentId = experimentId;
    }

    @Id
    public Long getExperimentId() {
        return this.experimentId;
    }

    public void setGroup(boolean group) {
        this.group = group;
    }

    @Transient
    public boolean isGroup() {
        return this.group;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ExperimentAccessPE)) {
            return false;
        }
        ExperimentAccessPE that = (ExperimentAccessPE)obj;
        EqualsBuilder builder = new EqualsBuilder();
        if (this.isGroup()) {
            builder.append((Object)this.getSpaceCode(), (Object)that.getSpaceCode());
            builder.append((Object)this.getProjectCode(), (Object)that.getProjectCode());
            builder.append((Object)this.getExperimentCode(), (Object)that.getExperimentCode());
        } else {
            builder.append((Object)this.getExperimentId(), (Object)that.getExperimentId());
        }
        return builder.isEquals();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        if (this.isGroup()) {
            builder.append((Object)this.getSpaceCode());
            builder.append((Object)this.getProjectCode());
            builder.append((Object)this.getExperimentCode());
        } else {
            builder.append((Object)this.getExperimentId());
        }
        return builder.toHashCode();
    }
}

