/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.systemsx.cisd.openbis.generic.shared.dto.AbstractGridExpressionPE;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="grid_custom_columns")
public class GridCustomColumnPE
extends AbstractGridExpressionPE<GridCustomColumnPE> {
    private static final long serialVersionUID = 35L;
    private String code;
    private String label;

    @Override
    @SequenceGenerator(name="GRID_CUSTOM_COLUMNS_ID_SEQ", sequenceName="GRID_CUSTOM_COLUMNS_ID_SEQ", allocationSize=1)
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="GRID_CUSTOM_COLUMNS_ID_SEQ")
    public final Long getId() {
        return this.id;
    }

    @Column(name="code")
    @NotNull(message="Code can not be null.")
    @Length(min=1, max=200, message="Given code '%s' is either too short (minimal length: {min} character) or too long (maximal length: {max} characters).")
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Column(name="label")
    @Length(max=128, message="Given label '%s' is too long (maximal length: {max} characters).")
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GridCustomColumnPE)) {
            return false;
        }
        GridCustomColumnPE that = (GridCustomColumnPE)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.getCode(), (Object)that.getCode());
        builder.append((Object)this.getGridId(), (Object)that.getGridId());
        return builder.isEquals();
    }

    public final int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getCode());
        builder.append((Object)this.getGridId());
        return builder.toHashCode();
    }

    public final String toString() {
        return this.getLabel();
    }

    @Override
    public int compareTo(GridCustomColumnPE that) {
        return this.getCode().compareTo(that.getCode());
    }
}

