/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.systemsx.cisd.openbis.generic.shared.dto.AbstractGridExpressionPE;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="filters")
public class GridCustomFilterPE
extends AbstractGridExpressionPE<GridCustomFilterPE> {
    private static final long serialVersionUID = 35L;
    private String name;

    @Override
    @SequenceGenerator(name="FILTER_ID_SEQ", sequenceName="FILTER_ID_SEQ", allocationSize=1)
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="FILTER_ID_SEQ")
    public final Long getId() {
        return this.id;
    }

    @Column(name="name")
    @NotNull(message="Name can not be null.")
    @Length(min=1, max=200, message="Given name '%s' is either too short (minimal length: {min} character) or too long (maximal length: {max} characters).")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GridCustomFilterPE)) {
            return false;
        }
        GridCustomFilterPE that = (GridCustomFilterPE)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.getName(), (Object)that.getName());
        builder.append((Object)this.getGridId(), (Object)that.getGridId());
        return builder.isEquals();
    }

    public final int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getName());
        builder.append((Object)this.getGridId());
        return builder.toHashCode();
    }

    public final String toString() {
        return this.getName();
    }

    @Override
    public int compareTo(GridCustomFilterPE that) {
        String thatName = that.getName();
        String thisName = this.getName();
        if (thisName == null) {
            return thatName == null ? 0 : -1;
        }
        if (thatName == null) {
            return 1;
        }
        return thisName.compareTo(thatName);
    }
}

