/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.systemsx.cisd.openbis.generic.shared.basic.CodeConverter;
import ch.systemsx.cisd.openbis.generic.shared.dto.HibernateAbstractRegistrationHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.IIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.hibernate.ManagedInternally;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="relationship_types", uniqueConstraints={@UniqueConstraint(columnNames={"code"})})
public class RelationshipTypePE
extends HibernateAbstractRegistrationHolder
implements IIdAndCodeHolder {
    private static final long serialVersionUID = 35L;
    private String simpleCode;
    private String description;
    private String label;
    private boolean managedInternally;
    private transient Long id;
    private String parentLabel;
    private String childLabel;

    public void setSimpleCode(String simpleCode) {
        this.simpleCode = simpleCode.toUpperCase();
    }

    @Column(name="code")
    @NotNull(message="Code can not be null.")
    @Length(min=1, max=100, message="Given code '%s' is either too short (minimal length: {min} character) or too long (maximal length: {max} characters).")
    @Pattern(regexp="^[A-Z0-9_\\-\\.]+$", flags={Pattern.Flag.CASE_INSENSITIVE}, message="Given code '%s' contains illegal characters (allowed: A-Z, a-z, 0-9 and _, -, .)")
    public String getSimpleCode() {
        return this.simpleCode;
    }

    public void setCode(String fullCode) {
        this.setManagedInternally(CodeConverter.isInternalNamespace(fullCode));
        this.setSimpleCode(CodeConverter.tryToDatabase(fullCode));
    }

    @Override
    @Transient
    public String getCode() {
        return CodeConverter.tryToBusinessLayer(this.getSimpleCode(), this.isManagedInternally());
    }

    @NotNull(message="Description can not be null.")
    @Column(name="description")
    @Length(max=2000, message="Given description '%s' is too long (maximal length: {max} characters).")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @NotNull(message="Label can not be null.")
    @Column(name="label")
    @Length(max=128, message="Given label '%s' is too long (maximal length: {max} characters).")
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @NotNull
    @Column(name="is_managed_internally")
    @ManagedInternally(message="Code contains '$' prefix.")
    public boolean isManagedInternally() {
        return this.managedInternally;
    }

    public void setManagedInternally(boolean managedInternally) {
        this.managedInternally = managedInternally;
    }

    @Override
    @SequenceGenerator(name="RELATIONSHIP_TYPE_ID_SEQ", sequenceName="RELATIONSHIP_TYPE_ID_SEQ", allocationSize=1)
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="RELATIONSHIP_TYPE_ID_SEQ")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @NotNull(message="Label can not be null.")
    @Column(name="parent_label")
    @Length(max=128, message="Given label '%s' is too long (maximal length: {max} characters).")
    public String getParentLabel() {
        return this.parentLabel;
    }

    public void setParentLabel(String parentLabel) {
        this.parentLabel = parentLabel;
    }

    @NotNull(message="Label can not be null.")
    @Column(name="child_label")
    @Length(max=128, message="Given label '%s' is too long (maximal length: {max} characters).")
    public String getChildLabel() {
        return this.childLabel;
    }

    public void setChildLabel(String childLabel) {
        this.childLabel = childLabel;
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RelationshipTypePE)) {
            return false;
        }
        RelationshipTypePE that = (RelationshipTypePE)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.getSimpleCode(), (Object)that.getSimpleCode());
        builder.append(this.isManagedInternally(), that.isManagedInternally());
        return builder.isEquals();
    }

    public final int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getSimpleCode());
        builder.append(this.isManagedInternally());
        return builder.toHashCode();
    }

    public final String toString() {
        return this.getCode();
    }
}

