/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import javax.persistence.Entity;
import javax.persistence.EntityResult;
import javax.persistence.Id;
import javax.persistence.NamedNativeQueries;
import javax.persistence.NamedNativeQuery;
import javax.persistence.SqlResultSetMapping;
import javax.persistence.Transient;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

@Entity
@SqlResultSetMapping(name="sample_access_implicit", entities={@EntityResult(entityClass=SampleAccessPE.class)})
@NamedNativeQueries(value={@NamedNativeQuery(name="sample_access_by_tech_ids", query="SELECT g.code as spaceCode, p.code as projectCode, ep.code as experimentProjectCode, e.code as experimentCode, s.code as sampleCode, s.id as sampleId, c.code as containerCode FROM samples s left outer join spaces g on s.space_id = g.id left outer join projects p on s.proj_id = p.id left outer join samples_all c on s.samp_id_part_of = c.id left outer join experiments_all e on s.expe_id = e.id left outer join projects ep on e.proj_id = ep.id WHERE s.id in (:ids)", resultSetMapping="sample_access_implicit"), @NamedNativeQuery(name="sample_access_by_perm_ids", query="SELECT g.code as spaceCode, p.code as projectCode, ep.code as experimentProjectCode, e.code as experimentCode, s.code as sampleCode, s.id as sampleId, c.code as containerCode FROM samples s left outer join spaces g on s.space_id = g.id left outer join projects p on s.proj_id = p.id left outer join samples_all c on s.samp_id_part_of = c.id left outer join experiments_all e on s.expe_id = e.id left outer join projects ep on e.proj_id = ep.id WHERE s.perm_id in (:ids)", resultSetMapping="sample_access_implicit"), @NamedNativeQuery(name="deleted_sample_access", query="SELECT g.code as spaceCode, p.code as projectCode, ep.code as experimentProjectCode, e.code as experimentCode, s.code as sampleCode, s.id as sampleId, c.code as containerCode FROM samples_deleted s left outer join spaces g on s.space_id = g.id left outer join projects p on s.proj_id = p.id left outer join samples_all c on s.samp_id_part_of = c.id left outer join experiments_all e on s.expe_id = e.id left outer join projects ep on e.proj_id = ep.id WHERE s.del_id in (:del_ids)", resultSetMapping="sample_access_implicit")})
public class SampleAccessPE {
    private static final String SAMPLE_ACCESS_QUERY_PART_1 = "SELECT g.code as spaceCode, p.code as projectCode, ep.code as experimentProjectCode, e.code as experimentCode, s.code as sampleCode, s.id as sampleId, c.code as containerCode FROM ";
    private static final String SAMPLE_ACCESS_QUERY_PART_2 = " s left outer join spaces g on s.space_id = g.id left outer join projects p on s.proj_id = p.id left outer join samples_all c on s.samp_id_part_of = c.id left outer join experiments_all e on s.expe_id = e.id left outer join projects ep on e.proj_id = ep.id ";
    public static final String SAMPLE_ACCESS_BY_TECH_IDS_QUERY = "SELECT g.code as spaceCode, p.code as projectCode, ep.code as experimentProjectCode, e.code as experimentCode, s.code as sampleCode, s.id as sampleId, c.code as containerCode FROM samples s left outer join spaces g on s.space_id = g.id left outer join projects p on s.proj_id = p.id left outer join samples_all c on s.samp_id_part_of = c.id left outer join experiments_all e on s.expe_id = e.id left outer join projects ep on e.proj_id = ep.id WHERE s.id in (:ids)";
    public static final String SAMPLE_ACCESS_BY_PERM_IDS_QUERY = "SELECT g.code as spaceCode, p.code as projectCode, ep.code as experimentProjectCode, e.code as experimentCode, s.code as sampleCode, s.id as sampleId, c.code as containerCode FROM samples s left outer join spaces g on s.space_id = g.id left outer join projects p on s.proj_id = p.id left outer join samples_all c on s.samp_id_part_of = c.id left outer join experiments_all e on s.expe_id = e.id left outer join projects ep on e.proj_id = ep.id WHERE s.perm_id in (:ids)";
    public static final String DELETED_SAMPLE_ACCESS_QUERY = "SELECT g.code as spaceCode, p.code as projectCode, ep.code as experimentProjectCode, e.code as experimentCode, s.code as sampleCode, s.id as sampleId, c.code as containerCode FROM samples_deleted s left outer join spaces g on s.space_id = g.id left outer join projects p on s.proj_id = p.id left outer join samples_all c on s.samp_id_part_of = c.id left outer join experiments_all e on s.expe_id = e.id left outer join projects ep on e.proj_id = ep.id WHERE s.del_id in (:del_ids)";
    public static final String SAMPLE_ACCESS_BY_TECH_IDS_QUERY_NAME = "sample_access_by_tech_ids";
    public static final String SAMPLE_ACCESS_BY_PERM_IDS_QUERY_NAME = "sample_access_by_perm_ids";
    public static final String DELETED_SAMPLE_ACCESS_QUERY_NAME = "deleted_sample_access";
    public static final String SAMPLE_IDS_PARAMETER_NAME = "ids";
    public static final String DELETION_IDS_PARAMETER_NAME = "del_ids";
    public static final String RESULT_SET_MAPPING = "sample_access_implicit";
    private String spaceCode;
    private String projectCode;
    private String experimentProjectCode;
    private String experimentCode;
    private Long sampleId;
    private String sampleCode;
    private String containerCode;
    private boolean group;

    public String getSpaceCode() {
        return this.spaceCode;
    }

    public void setSpaceCode(String spaceCode) {
        this.spaceCode = spaceCode;
    }

    @Transient
    public SpaceIdentifier getSpaceIdentifier() {
        if (this.getSpaceCode() != null) {
            return new SpaceIdentifier(this.getSpaceCode());
        }
        return null;
    }

    @Transient
    public ProjectIdentifier getProjectIdentifier() {
        if (this.getSpaceCode() != null) {
            if (this.getProjectCode() != null) {
                return new ProjectIdentifier(this.getSpaceCode(), this.getProjectCode());
            }
            if (this.getExperimentProjectCode() != null) {
                return new ProjectIdentifier(this.getSpaceCode(), this.getExperimentProjectCode());
            }
        }
        return null;
    }

    public String getProjectCode() {
        return this.projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getExperimentProjectCode() {
        return this.experimentProjectCode;
    }

    public void setExperimentProjectCode(String experimentProjectCode) {
        this.experimentProjectCode = experimentProjectCode;
    }

    public String getExperimentCode() {
        return this.experimentCode;
    }

    public void setExperimentCode(String experimentCode) {
        this.experimentCode = experimentCode;
    }

    public void setSampleId(Long sampleId) {
        this.sampleId = sampleId;
    }

    @Id
    public Long getSampleId() {
        return this.sampleId;
    }

    public String getSampleCode() {
        return this.sampleCode;
    }

    public void setSampleCode(String sampleCode) {
        this.sampleCode = sampleCode;
    }

    public String getContainerCode() {
        return this.containerCode;
    }

    public void setContainerCode(String containerCode) {
        this.containerCode = containerCode;
    }

    public void setGroup(boolean group) {
        this.group = group;
    }

    @Transient
    public boolean isGroup() {
        return this.group;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SampleAccessPE)) {
            return false;
        }
        SampleAccessPE that = (SampleAccessPE)obj;
        EqualsBuilder builder = new EqualsBuilder();
        if (this.isGroup()) {
            builder.append((Object)this.getSpaceCode(), (Object)that.getSpaceCode());
            builder.append((Object)this.getProjectCode(), (Object)that.getProjectCode());
            builder.append((Object)this.getExperimentProjectCode(), (Object)that.getExperimentProjectCode());
            builder.append((Object)this.getExperimentCode(), (Object)that.getExperimentCode());
            builder.append((Object)this.getSampleCode(), (Object)that.getSampleCode());
            builder.append((Object)this.getContainerCode(), (Object)that.getContainerCode());
        } else {
            builder.append((Object)this.getSampleId(), (Object)that.getSampleId());
        }
        return builder.isEquals();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        if (this.isGroup()) {
            builder.append((Object)this.getSpaceCode());
            builder.append((Object)this.getProjectCode());
            builder.append((Object)this.getExperimentProjectCode());
            builder.append((Object)this.getExperimentCode());
            builder.append((Object)this.getSampleCode());
            builder.append((Object)this.getContainerCode());
        } else {
            builder.append((Object)this.getSampleId());
        }
        return builder.toHashCode();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

